/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CalSettingsDialog
extends CenteredDialog {
    private boolean submitted = false;
    private CalSignalSettings settings = null;
    private JDialog parent;
    private JTextField freqField;
    private JLabel freqLabel;
    private JTextField ampField;
    private JLabel ampLabel;
    private JTextField durField;
    private JLabel durLabel;
    protected JButton okButton;
    protected JButton cancelButton;

    public CalSettingsDialog(JDialog parent) {
        super(parent, true);
        this.parent = parent;
        Container content = this.getContentPane();
        content.setLayout(null);
        this.setVisible(false);
        this.setSize(397, 201);
        this.freqField = new JTextField();
        this.freqField.setBounds(216, 36, 72, 23);
        content.add(this.freqField);
        this.freqLabel = new JLabel("Frequency (Hz)");
        this.freqLabel.setBounds(108, 36, 96, 23);
        this.freqLabel.setFont(new Font("Dialog", 1, 12));
        content.add(this.freqLabel);
        this.ampField = new JTextField();
        this.ampField.setBounds(216, 60, 72, 23);
        content.add(this.ampField);
        this.ampLabel = new JLabel("Amplitude (um/s)");
        this.ampLabel.setBounds(108, 60, 96, 23);
        this.ampLabel.setFont(new Font("Dialog", 1, 12));
        content.add(this.ampLabel);
        this.durField = new JTextField();
        this.durField.setBounds(216, 84, 72, 23);
        content.add(this.durField);
        this.durLabel = new JLabel("Duration (sec)");
        this.durLabel.setBounds(108, 84, 96, 23);
        this.durLabel.setFont(new Font("Dialog", 1, 12));
        content.add(this.durLabel);
        this.okButton = new JButton(" OK ");
        this.okButton.setMnemonic('O');
        this.okButton.setBounds(48, 144, 120, 24);
        this.okButton.setFont(new Font("Dialog", 1, 12));
        content.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setBounds(228, 144, 120, 24);
        this.cancelButton.setFont(new Font("Dialog", 1, 12));
        content.add(this.cancelButton);
        this.setTitle("Calibration Settings");
        this.setResizable(false);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.okButton.addActionListener(buttonHandler);
        this.cancelButton.addActionListener(buttonHandler);
    }

    public void applySettings(CalSignalSettings newSettings) {
        this.settings = newSettings;
        this.freqField.setText("" + this.settings.getFrequency());
        this.ampField.setText("" + this.settings.getAmplitude());
        this.durField.setText("" + this.settings.getDuration());
    }

    private double getDoubleField(JTextField field, String fieldName) {
        try {
            Double d = new Double(field.getText());
            return d;
        }
        catch (NumberFormatException nfe) {
            ErrorDialog edb = new ErrorDialog(this.parent, "Invalid Numeric Input");
            edb.setText("Error in " + fieldName, "", "The value entered: " + field.getText(), "is not a number.");
            edb.setVisible(true);
            throw nfe;
        }
    }

    void okButtonSelected() {
        try {
            double frequency = this.getDoubleField(this.freqField, this.freqLabel.getText());
            double amplitude = this.getDoubleField(this.ampField, this.ampLabel.getText());
            double duration = this.getDoubleField(this.durField, this.durLabel.getText());
            if (this.settings != null) {
                this.settings.setFrequency(frequency);
                this.settings.setAmplitude(amplitude);
                this.settings.setDuration(duration);
            }
            this.submitted = true;
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void cancelButtonSelected() {
        this.submitted = false;
        this.dispose();
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == CalSettingsDialog.this.okButton) {
                CalSettingsDialog.this.okButtonSelected();
            } else if (object == CalSettingsDialog.this.cancelButton) {
                CalSettingsDialog.this.cancelButtonSelected();
            }
        }
    }
}

