/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;

public class CalibrationChannel
implements Selectable {
    private CalibrationInfo info;
    private boolean selected;

    public CalibrationChannel(CalibrationInfo params) {
        this.info = params;
        this.selected = false;
    }

    public CalibrationInfo getInfo() {
        return this.info;
    }

    public String getChannelName() {
        return this.info.getChannelName();
    }

    public String getSensorName() {
        return this.info.getSensorName();
    }

    public String getInstrumentName() {
        return Instrument.getNameOf(this.getInstrumentID());
    }

    public int getKey() {
        return this.info.getKey();
    }

    public int getInstrumentID() {
        return ChannelKey.getIDOf(this.getKey());
    }

    public int getChannelNumber() {
        return 1 + ChannelKey.getChannelOf(this.getKey());
    }

    public int getCalEnable() {
        return this.info.getCalEnable();
    }

    public int getCalRelay() {
        return this.info.getCalRelay();
    }

    public int getCalUnits() {
        return this.info.getCalUnits();
    }

    public double getCoilResistance() {
        return this.info.getCoilResistance();
    }

    public double getCoilConstant() {
        return this.info.getCoilConstant();
    }

    public int getCalbrationSource() {
        return this.info.getCalSource();
    }

    public boolean isSharedCoil() {
        return this.info.isSharedCoil();
    }

    public boolean isSelectable() {
        return this.getCalEnable() > 0 || this.getCalRelay() > 0;
    }

    public void setSelected(boolean select) {
        if (this.isSelectable()) {
            this.selected = select;
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean compels(CalibrationChannel target) {
        if (this.getInstrumentID() != target.getInstrumentID()) {
            return false;
        }
        if (!this.isSelectable() || !target.isSelectable()) {
            return false;
        }
        int relay = this.getCalRelay();
        int enable = this.getCalEnable();
        int targetRelay = target.getCalRelay();
        int targetEnable = target.getCalEnable();
        if (relay == targetRelay && enable == targetEnable) {
            return true;
        }
        if (relay == targetRelay && targetEnable == 0) {
            return true;
        }
        return enable == targetEnable && targetRelay == 0;
    }

    public boolean hasCompatibleParams(CalibrationChannel target) {
        if (this.getInstrumentID() != target.getInstrumentID()) {
            return true;
        }
        if (this.getCalRelay() <= 0 || target.getCalRelay() <= 0) {
            return true;
        }
        return this.isSharedCoil() == target.isSharedCoil() && this.getCalUnits() == target.getCalUnits() && this.getCoilResistance() == target.getCoilResistance() && this.getCoilConstant() == target.getCoilConstant() && this.getCalbrationSource() == target.getCalbrationSource();
    }
}

