/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationInfo;

public class CalibrationSet {
    public static final double dacResistance = 500.0;
    public static final double maxVolts = 5.0;
    public static final double maxAmps = 0.035;
    public static final int HRD_CAL = 0;
    public static final int TRIDENT_CAL = 1;
    public static final int CURRENT_CAL = 0;
    public static final int VOLTAGE_CAL = 1;
    public static final int HRD_VOLTAGE = 0;
    public static final int TRIDENT_VOLTS = 1;
    public static final int TRIDENT_AMPS = 2;
    private int ID = -1;
    private int relayBits = 0;
    private boolean sharedCoil = false;
    private int enableBits = 0;
    private int calUnits = 0;
    private double coilResistance = 1.0;
    private double coilConstant = 1.0;
    private int calSource;

    public CalibrationSet() {
    }

    public CalibrationSet(CalibrationInfo channel) {
        this.add(channel);
    }

    private void add(CalibrationInfo channel) {
        int relay;
        if (this.ID < 0) {
            this.ID = channel.getInstrumentID();
        }
        if (this.relayBits == 0) {
            this.calUnits = channel.getCalUnits();
            this.coilResistance = channel.getCoilResistance();
            this.coilConstant = channel.getCoilConstant();
            this.sharedCoil = channel.isSharedCoil();
            this.calSource = channel.getCalSource();
        }
        if ((relay = channel.getCalRelay()) < 1 || relay > 6) {
            relay = 0;
        }
        this.relayBits |= 1 << relay >> 1;
        int enable = channel.getCalEnable();
        if (enable < 1 || enable > 3) {
            enable = 0;
        }
        this.enableBits |= 1 << enable >> 1;
    }

    public boolean isCompatible(CalibrationInfo channel) {
        if (this.ID >= 0 && channel.getInstrumentID() != this.ID) {
            return false;
        }
        if (this.relayBits == 0 || channel.getCalRelay() == 0) {
            return true;
        }
        return this.isSharedCoil() == channel.isSharedCoil() && this.getCalUnits() == channel.getCalUnits() && this.getCoilResistance() == channel.getCoilResistance() && this.getCoilConstant() == channel.getCoilConstant() && this.getCalSource() == channel.getCalSource();
    }

    public boolean addChannel(CalibrationInfo channel) {
        if (this.isCompatible(channel)) {
            this.add(channel);
            return true;
        }
        return false;
    }

    public int countRelays() {
        int count = 0;
        int bit = 1;
        while (bit < 64) {
            if ((this.relayBits & bit) == bit) {
                ++count;
            }
            bit *= 2;
        }
        return count;
    }

    public double getMaxVelocity(double frequency) {
        double unitResponse = this.getAmplitude(frequency, 1.0);
        if (unitResponse == 0.0) {
            return 0.0;
        }
        if (this.calSource == 1 && this.calUnits == 0) {
            return 0.035 / unitResponse;
        }
        return 5.0 / unitResponse;
    }

    public double getAmplitude(double frequency, double velocity) {
        int numRelays = this.countRelays();
        if (numRelays == 0) {
            return 0.0;
        }
        if (this.isSharedCoil()) {
            numRelays = 1;
        }
        double accn = Math.PI * 2 * frequency * velocity * 1.0E-6;
        if (this.calSource == 1) {
            if (this.calUnits == 1) {
                return this.coilConstant * accn;
            }
            return (double)numRelays * this.coilConstant * accn;
        }
        double cfactor = this.calUnits == 1 ? this.coilResistance : 1.0;
        double coilAmps = this.coilConstant * accn / cfactor;
        double totalAmps = (double)numRelays * coilAmps;
        return totalAmps * (500.0 + this.coilResistance / (double)numRelays);
    }

    public double getClippedAmplitude(double frequency, double velocity) {
        double amplitude = this.getAmplitude(frequency, velocity);
        if (this.calSource == 1 && this.calUnits == 0) {
            return Math.min(amplitude, 0.035);
        }
        return Math.min(amplitude, 5.0);
    }

    public int getCalType() {
        if (this.calSource == 1) {
            if (this.calUnits == 1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    protected int getCalUnits() {
        return this.calUnits;
    }

    protected int getRelayBits() {
        return this.relayBits;
    }

    protected int getEnableBits() {
        return this.enableBits;
    }

    protected int getInstrumentID() {
        return this.ID;
    }

    protected boolean isSharedCoil() {
        return this.sharedCoil;
    }

    protected double getCoilResistance() {
        return this.coilResistance;
    }

    protected double getCoilConstant() {
        return this.coilConstant;
    }

    protected int getCalSource() {
        return this.calSource;
    }
}

