/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class CenteredDialog
extends JDialog {
    private boolean neverShown = true;

    public CenteredDialog(JFrame parent) {
        super(parent);
        this.addWindowListener(new WindowCloser());
    }

    public CenteredDialog(JDialog parent) {
        super(parent);
        this.addWindowListener(new WindowCloser());
    }

    public CenteredDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.addWindowListener(new WindowCloser());
    }

    public CenteredDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.addWindowListener(new WindowCloser());
    }

    public void setVisible(boolean makeVisible) {
        if (makeVisible && this.neverShown) {
            this.neverShown = false;
            Rectangle bounds = this.getBounds();
            Rectangle pBounds = this.getParent().getBounds();
            int x = pBounds.x + (pBounds.width - bounds.width) / 2;
            int y = pBounds.y + (pBounds.height - bounds.height) / 2;
            Dimension scr = this.getToolkit().getScreenSize();
            Rectangle sBounds = new Rectangle(scr);
            if (!sBounds.contains(x, y) || !sBounds.contains(x + bounds.width, y + bounds.height)) {
                x = sBounds.x + (sBounds.width - bounds.width) / 2;
                y = sBounds.y + (sBounds.height - bounds.height) / 2;
            }
            this.setLocation(x, y);
        }
        super.setVisible(makeVisible);
    }

    protected void beep() {
        this.getToolkit().beep();
    }

    void closeWindow() {
        this.dispose();
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == CenteredDialog.this) {
                CenteredDialog.this.closeWindow();
            }
        }
    }
}

