/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.NmxHelp;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ColumnSettingsDialog
extends CenteredDialog {
    private GradingThresholdTable originalTable;
    private GradingThresholdTable scratchTable;
    private String currentItem = "";
    private JDialog parent;
    private boolean submitted = false;
    protected JComboBox selector;
    protected JButton okButton;
    protected JButton cancelButton;
    private JLabel selectorPrompt;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;

    public ColumnSettingsDialog(JDialog parent, GradingThresholdTable gtt) {
        super(parent, true);
        this.parent = parent;
        this.originalTable = gtt;
        this.scratchTable = new GradingThresholdTable(gtt);
        this.initializeControls();
        Enumeration keys = this.scratchTable.keys();
        while (keys.hasMoreElements()) {
            String str = (String)keys.nextElement();
            String lastUpdateString = NmxHelp.getFieldName("lastupdate");
            this.selector.addItem(str);
        }
        if (this.selector.getItemCount() > 0) {
            this.selector.setSelectedIndex(0);
            this.displaySelectedItem();
        }
    }

    private JLabel makeColorBar(String name, Color color) {
        JLabel colorBar = new JLabel(name, 0);
        colorBar.setBackground(color);
        colorBar.setForeground(Color.black);
        colorBar.setOpaque(true);
        return colorBar;
    }

    private void initializeControls() {
        Container content = this.getContentPane();
        content.setLayout(null);
        this.setVisible(false);
        this.setSize(430, 354);
        this.selectorPrompt = new JLabel("Enter display thresholds for:");
        this.selectorPrompt.setBounds(51, 108, 167, 22);
        this.selectorPrompt.setFont(new Font("Dialog", 1, 12));
        content.add(this.selectorPrompt);
        this.selector = new JComboBox();
        this.selector.setBounds(51, 132, 167, 22);
        content.add(this.selector);
        int xloc = 288;
        int ystart = 12;
        int yspace = 48;
        int width = 84;
        int height = 22;
        this.textField1 = new JTextField();
        this.textField1.setBounds(xloc, ystart + yspace, width, height);
        content.add(this.textField1);
        this.textField2 = new JTextField();
        this.textField2.setBounds(xloc, ystart + 2 * yspace, width, height);
        content.add(this.textField2);
        this.textField3 = new JTextField();
        this.textField3.setBounds(xloc, ystart + 3 * yspace, width, height);
        content.add(this.textField3);
        this.textField4 = new JTextField();
        this.textField4.setBounds(xloc, ystart + 4 * yspace, width, height);
        content.add(this.textField4);
        xloc = 288;
        ystart = -12;
        yspace = 48;
        width = 84;
        height = 22;
        JLabel colorBar = this.makeColorBar("Low", Color.red);
        colorBar.setBounds(xloc, ystart + yspace, width, height);
        content.add(colorBar);
        colorBar = this.makeColorBar("Marginal", Color.yellow);
        colorBar.setBounds(xloc, ystart + 2 * yspace, width, height);
        content.add(colorBar);
        colorBar = this.makeColorBar("OK", Color.green);
        colorBar.setBounds(xloc, ystart + 3 * yspace, width, height);
        content.add(colorBar);
        colorBar = this.makeColorBar("Marginal", Color.yellow);
        colorBar.setBounds(xloc, ystart + 4 * yspace, width, height);
        content.add(colorBar);
        colorBar = this.makeColorBar("High", Color.red);
        colorBar.setBounds(xloc, ystart + 5 * yspace, width, height);
        content.add(colorBar);
        this.okButton = new JButton(" OK ");
        this.okButton.setMnemonic('O');
        this.okButton.setBounds(60, 288, 120, 30);
        this.okButton.setFont(new Font("Dialog", 1, 12));
        content.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setBounds(252, 288, 120, 30);
        this.cancelButton.setFont(new Font("Dialog", 1, 12));
        content.add(this.cancelButton);
        this.setTitle("Set Column Color Thresholds");
        this.setResizable(false);
        this.selector.addActionListener(new SelectionHandler());
        ButtonHandler buttonHandler = new ButtonHandler();
        this.okButton.addActionListener(buttonHandler);
        this.cancelButton.addActionListener(buttonHandler);
    }

    private void displaySelectedItem() {
        GradingThresholds gt;
        this.currentItem = this.selector.getSelectedItem().toString();
        if (this.currentItem == null) {
            this.currentItem = "";
        }
        if ((gt = this.scratchTable.get(this.currentItem)) != null) {
            this.textField1.setText("" + gt.getThreshold1());
            this.textField2.setText("" + gt.getThreshold2());
            this.textField3.setText("" + gt.getThreshold3());
            this.textField4.setText("" + gt.getThreshold4());
        } else {
            this.textField1.setText("");
            this.textField2.setText("");
            this.textField3.setText("");
            this.textField4.setText("");
        }
    }

    private double getDoubleField(JTextField field, String fieldName) {
        try {
            Double d = new Double(field.getText());
            return d;
        }
        catch (NumberFormatException nfe) {
            ErrorDialog edb = new ErrorDialog(this.parent, "Invalid Numeric Input");
            edb.setText("Error in " + fieldName, "", "The value entered: " + field.getText(), "is not a number.");
            edb.setVisible(true);
            throw nfe;
        }
    }

    private boolean saveCurrentItem() {
        block4: {
            GradingThresholds gt = this.scratchTable.get(this.currentItem);
            if (gt == null) {
                return true;
            }
            try {
                double t1 = this.getDoubleField(this.textField1, "threshold 1");
                double t2 = this.getDoubleField(this.textField2, "threshold 2");
                double t3 = this.getDoubleField(this.textField3, "threshold 3");
                double t4 = this.getDoubleField(this.textField4, "threshold 4");
                if (!(t1 <= t2) || !(t2 <= t3) || !(t3 <= t4)) break block4;
                gt.setThresholds(t1, t2, t3, t4);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        ErrorDialog edb = new ErrorDialog(this.parent, "Invalid Thresholds");
        edb.setText("", "Thresholds must be increasing", "", "i.e.  t1 <= t2 <= t3 <= t4");
        edb.setVisible(true);
        return false;
    }

    void selector_ItemStateChanged() {
        if (this.currentItem.equalsIgnoreCase(this.selector.getSelectedItem().toString())) {
            return;
        }
        boolean savedOK = this.saveCurrentItem();
        if (savedOK) {
            this.displaySelectedItem();
        } else {
            this.selector.setSelectedItem(this.currentItem);
        }
    }

    void okButtonSelected() {
        boolean savedOK = this.saveCurrentItem();
        if (savedOK) {
            this.originalTable.copyTable(this.scratchTable);
            this.submitted = true;
            this.dispose();
        }
    }

    void cancelButtonSelected() {
        this.dispose();
    }

    public boolean isOk() {
        return this.submitted;
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ColumnSettingsDialog.this.okButton) {
                ColumnSettingsDialog.this.okButtonSelected();
            } else if (object == ColumnSettingsDialog.this.cancelButton) {
                ColumnSettingsDialog.this.cancelButtonSelected();
            }
        }
    }

    class SelectionHandler
    implements ActionListener {
        SelectionHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ColumnSettingsDialog.this.selector) {
                ColumnSettingsDialog.this.selector_ItemStateChanged();
            }
        }
    }
}

