/*
 * Decompiled with CFR 0.152.
 */
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCMultiColLegend;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class CombineAllPlots
extends HistoryPanel {
    Vector plotDatas;
    ChartDataSource source;

    public CombineAllPlots(Vector somePlotDatas, double startTime, double endTime, int choice, boolean doFirstDiff) {
        super(startTime, endTime, ((PlotData)somePlotDatas.get(0)).getVariableName(), choice, doFirstDiff);
        this.plotDatas = somePlotDatas;
        this.setPlotName("All Data");
        int rows = (int)Math.ceil((double)this.plotDatas.size() / 2.0) + 1;
        int height = 220 + rows * 30;
        this.setPreferredSize(new Dimension(500, height));
        if (!this.createChart()) {
            this.setIsPlot(false);
            JTextArea area = new JTextArea("No Data To Plot for stations:\n" + this.getStationList());
            area.setForeground(Color.red);
            area.setBackground(Color.white);
            area.setEditable(false);
            this.add(area);
            this.setPreferredSize(new Dimension(500, 30));
            this.setSuccess(false);
        }
    }

    private String getStationList() {
        String retStr = "";
        Iterator iter = this.plotDatas.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            if (retStr.length() > 0) {
                retStr = String.valueOf(retStr) + ",\n";
            }
            retStr = String.valueOf(retStr) + data.getNode().getName();
            retStr = data.getVariableName() == null || data.getVariableName().trim() == "" ? String.valueOf(retStr) : String.valueOf(retStr) + "." + data.getVariableName();
        }
        return retStr.substring(0, retStr.length());
    }

    protected boolean createChart() {
        this.chart = new JCChart();
        this.source = new ChartDataSource();
        if (this.plotDatas == null || this.plotDatas.size() == 0) {
            return false;
        }
        Collections.sort(this.plotDatas);
        PlotData data = null;
        Iterator iter = this.plotDatas.iterator();
        while (iter.hasNext()) {
            double[] x;
            double[] y;
            data = (PlotData)iter.next();
            if (data == null || (y = this.getDataSeries(data)) == null || (x = this.getTimeSeries(data)) == null) continue;
            try {
                this.source.addSeries(x, y, String.valueOf(data.getNode().getName()) + " - " + data.getNode().getReadingName(), data.getColor(), data.getNode().getPrecision());
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.source.getNumSeries() <= 0) {
            return false;
        }
        this.chart.getDataView(0).setDataSource((ChartDataModel)this.source);
        this.chart.getDataView(0).setHoleValue(this.source.getHoleValue());
        JCChartArea chartArea = this.chart.getChartArea();
        JCAxis xAxis = chartArea.getXAxis(0);
        xAxis.setMin(this.source.getMinXValue());
        xAxis.setMax(this.source.getMaxXValue());
        xAxis.setLabelGenerator((JCLabelGenerator)new ChartTimeLabelGenerator("Md_HH:mm:ss"));
        String titleStr = this.getDate(this.source.getMinXValue(), this.source.getMaxXValue());
        if (this.firstDiff) {
            titleStr = "First Differences  " + titleStr;
        }
        JCAxisTitle xAxisTitle = new JCAxisTitle(titleStr);
        xAxisTitle.setPlacement(32);
        xAxis.setTitle(xAxisTitle);
        JCAxis yAxis = chartArea.getYAxis(0);
        yAxis.setPlacement(1);
        yAxis.setPrecision(data.getPrecision());
        HistoryPanel.MinMaxCalculator calc = new HistoryPanel.MinMaxCalculator(this, this.source.getMinValue(), this.source.getMaxValue(), this.source.getPrecision());
        yAxis.setMin(calc.getMinValue());
        yAxis.setMax(calc.getMaxValue());
        yAxis.setOriginPlacement(3);
        int i = 0;
        while (i < this.source.getNumSeries()) {
            ChartDataViewSeries series = this.chart.getDataView(0).getSeries(i);
            JCChartStyle oldStyle = series.getStyle();
            Color color = this.source.getColor(i);
            if (color == null) {
                color = Color.black;
            }
            JCLineStyle line = new JCLineStyle(1, color, 1);
            JCChartStyle style = new JCChartStyle(line, oldStyle.getFillStyle(), new JCSymbolStyle(0, null, 0));
            series.setStyle(style);
            ++i;
        }
        ChartDataView dataView = this.chart.getDataView(0);
        dataView.setName("");
        int i2 = 0;
        while (i2 < this.source.getNumSeries()) {
            ChartDataViewSeries series = dataView.getSeries(i2);
            series.setLabel(this.source.getDataTag(i2));
            ++i2;
        }
        int numItems = this.source.getNumSeries();
        if (numItems < 4) {
            JCLegend legend = this.chart.getLegend();
            legend.setBorder(BorderFactory.createLineBorder(Color.black));
            legend.setAnchor(32);
            legend.setVisible(true);
            this.chart.setLegend(legend);
        } else {
            JCMultiColLegend mcl = new JCMultiColLegend();
            mcl.setNumColumns(2);
            mcl.setBorder(BorderFactory.createLineBorder(Color.black));
            mcl.setAnchor(32);
            mcl.setVisible(true);
            this.chart.setLegend((JCLegend)mcl);
        }
        JLabel label = (JLabel)this.chart.getHeader();
        label.setText(this.getPlotName());
        this.chart.getHeader().setVisible(true);
        this.chart.setBackground(Color.white);
        this.chart.setAllowUserChanges(true);
        this.chart.setTrigger(0, new EventTrigger(1, 6));
        this.chart.addMouseListener((MouseListener)new HistoryPanel.ChartMouseListener(this));
        this.add((Component)this.chart, "Center");
        return true;
    }

    public Vector getData() {
        return this.plotDatas;
    }

    public void saveData(String dirName) {
        Vector pData = this.getData();
        Iterator iter = pData.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            this.saveData(data.getNode(), dirName);
        }
    }

    class ChartDataSource
    implements ChartDataModel,
    HoleValueChartDataModel {
        private ArrayList ySeries = new ArrayList();
        private ArrayList xSeries = new ArrayList();
        private ArrayList dataTags = new ArrayList();
        private ArrayList colors = new ArrayList();
        private double maxVal = -1.7976931348623157E308;
        private double minVal = Double.MAX_VALUE;
        private double minXVal = Double.MAX_VALUE;
        private double maxXVal = -1.7976931348623157E308;
        private int prec = 0;

        ChartDataSource() {
        }

        public int getNumSeries() {
            return this.ySeries.size();
        }

        public String getDataTag(int param) {
            if (this.dataTags.size() > param) {
                return (String)this.dataTags.get(param);
            }
            return null;
        }

        public Color getColor(int param) {
            if (this.colors.size() > param) {
                return (Color)this.colors.get(param);
            }
            return null;
        }

        public double[] getXSeries(int param) {
            ArrayList series = (ArrayList)this.xSeries.get(param);
            double[] x = new double[series.size()];
            int i = 0;
            while (i < series.size()) {
                Double val = (Double)series.get(i);
                x[i] = val;
                ++i;
            }
            return x;
        }

        public double[] getYSeries(int param) {
            ArrayList series = (ArrayList)this.ySeries.get(param);
            double[] y = new double[series.size()];
            int i = 0;
            while (i < series.size()) {
                Double val = (Double)series.get(i);
                y[i] = val;
                ++i;
            }
            return y;
        }

        public void addSeries(double[] x, double[] y, String tag, Color color, int precision) throws Exception {
            if (x.length != y.length) {
                throw new Exception("Combined History Panel.  Series are different lengths");
            }
            ArrayList<Double> yList = new ArrayList<Double>();
            ArrayList<Double> xList = new ArrayList<Double>();
            int currInt = x.length < 4 ? -1 : (int)Math.abs(x[0] - x[1]);
            int i = 0;
            while (i < y.length) {
                this.setMinMax(y[i], x[i]);
                if (currInt > 0 && i < y.length - 1) {
                    int newInt = (int)Math.abs(x[i] - x[i + 1]);
                    if ((double)newInt > (double)currInt * 1.2 || (double)newInt < (double)currInt * 0.8) {
                        Double lastY = (Double)yList.get(xList.size() - 1);
                        yList.add(new Double(y[i]));
                        xList.add(new Double(x[i]));
                        if (lastY.doubleValue() != this.getHoleValue()) {
                            xList.add(new Double(x[i] + (x[i + 1] - x[i]) / 2.0));
                            yList.add(new Double(this.getHoleValue()));
                        }
                        currInt = newInt;
                    } else {
                        yList.add(new Double(y[i]));
                        xList.add(new Double(x[i]));
                    }
                } else {
                    yList.add(new Double(y[i]));
                    xList.add(new Double(x[i]));
                }
                ++i;
            }
            this.ySeries.add(yList);
            this.xSeries.add(xList);
            this.dataTags.add(tag);
            this.colors.add(color);
            if (this.prec < precision) {
                this.prec = precision;
            }
        }

        private void setMinMax(double y, double x) {
            if (this.minXVal > x) {
                this.minXVal = x;
            }
            if (this.maxXVal < x) {
                this.maxXVal = x;
            }
            if (y == this.getHoleValue()) {
                return;
            }
            if (y > this.maxVal) {
                this.maxVal = y;
            }
            if (y < this.minVal) {
                this.minVal = y;
            }
        }

        public double getMinXValue() {
            return this.minXVal;
        }

        public double getMaxXValue() {
            return this.maxXVal;
        }

        public double getMinValue() {
            return this.minVal;
        }

        public double getMaxValue() {
            return this.maxVal;
        }

        public int getPrecision() {
            return this.prec;
        }

        public double getHoleValue() {
            return Double.MAX_VALUE;
        }
    }
}

