/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class ComponentStateRecorder
implements ComponentListener {
    private Component component;
    private ComponentState state;

    public ComponentStateRecorder(Component comp, ComponentState theState) {
        this.component = comp;
        this.state = theState;
    }

    private void recordBounds() {
        Rectangle bounds = this.component.getBounds();
        if (bounds.x + bounds.width >= 0 && bounds.y + bounds.height >= 0) {
            this.state.setBounds(bounds);
        }
    }

    public void componentShown(ComponentEvent e) {
        this.state.setVisible(true);
    }

    public void componentHidden(ComponentEvent e) {
        this.state.setVisible(false);
    }

    public void componentResized(ComponentEvent e) {
        this.recordBounds();
    }

    public void componentMoved(ComponentEvent e) {
        this.recordBounds();
    }
}

