/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.MsgClient;
import ca.nanometrics.msg.StatusMonitor;
import ca.nanometrics.vmodel.BooleanModel;
import ca.nanometrics.vmodel.BooleanModelCheckBox;
import ca.nanometrics.vmodel.IntegerModel;
import ca.nanometrics.vmodel.IntegerModelTextField;
import ca.nanometrics.vmodel.StringModel;
import ca.nanometrics.vmodel.StringModelTextField;
import ca.nanometrics.vmodel.ValueListener;
import java.awt.Dimension;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ConnectionController
extends ControlBar
implements ValueListener {
    private MsgClient client;
    protected JLabel statusField;
    private boolean updating = false;
    private boolean needsUpdate = false;
    private StringModel naqsHost;
    private IntegerModel naqsPort;
    private BooleanModel callback;
    private BooleanModel connect;

    public ConnectionController(MsgClient mClient) {
        if (mClient == null) {
            throw new IllegalArgumentException("null client in ConnectionController");
        }
        this.client = mClient;
        StringModelTextField hostField = new StringModelTextField(this.getNaqsHostModel(), 15);
        Dimension mins = hostField.getPreferredSize();
        hostField.setMinimumSize(mins);
        this.addControl(new LabelledComponent(" host: ", (JComponent)hostField), false);
        IntegerModelTextField portField = new IntegerModelTextField(this.getNaqsPortModel(), 5);
        portField.setMinimumSize(portField.getPreferredSize());
        this.addControl(new LabelledComponent(" port: ", (JComponent)portField), false);
        BooleanModelCheckBox callback = new BooleanModelCheckBox(" callback socket", this.getCallbackModel());
        this.addLabelledControl("", callback, false);
        BooleanModelCheckBox connect = new BooleanModelCheckBox(" connect", this.getConnectModel());
        this.addLabelledControl("", connect, false);
        this.statusField = new JLabel("    ");
        this.addLabelledControl("", this.statusField, true);
        this.getNaqsHostModel().addValueListener(this);
        this.getNaqsPortModel().addValueListener(this);
        this.getCallbackModel().addValueListener(this);
        this.getConnectModel().addValueListener(this);
        this.client.setMonitor(new ClientMonitor());
    }

    private void applyNaqsHostSettings(ConnectionSettings settings) {
        this.getNaqsHostModel().setValue(settings.getNaqsHost());
    }

    private StringModel getNaqsHostModel() {
        if (this.naqsHost == null) {
            this.naqsHost = new StringModel();
            this.naqsHost.setValue("localhost");
        }
        return this.naqsHost;
    }

    private String getNaqsHost() {
        return this.getNaqsHostModel().getValue();
    }

    private void applyNaqsPortSettings(ConnectionSettings settings) {
        this.getNaqsPortModel().setValue(settings.getNaqsPort());
    }

    private IntegerModel getNaqsPortModel() {
        if (this.naqsPort == null) {
            this.naqsPort = new IntegerModel();
            this.naqsPort.setValue(28000);
        }
        return this.naqsPort;
    }

    private int getNaqsPort() {
        return this.getNaqsPortModel().getValue();
    }

    private void applyCallbackModelSettings(ConnectionSettings settings) {
        this.getCallbackModel().setValue(settings.isCallback());
    }

    private BooleanModel getCallbackModel() {
        if (this.callback == null) {
            this.callback = new BooleanModel();
        }
        return this.callback;
    }

    private boolean isCallback() {
        return this.getCallbackModel().getValue();
    }

    private void applyConnectModelSettings(ConnectionSettings settings) {
        this.getConnectModel().setValue(settings.isConnect());
    }

    private BooleanModel getConnectModel() {
        if (this.connect == null) {
            this.connect = new BooleanModel();
        }
        return this.connect;
    }

    private boolean isConnect() {
        return this.getConnectModel().getValue();
    }

    public synchronized void applySettings(NaqsViewSettings naqsSettings) {
        ConnectionSettings settings = naqsSettings.getConnectionSettings();
        this.applyCallbackModelSettings(settings);
        this.applyConnectModelSettings(settings);
        this.applyNaqsHostSettings(settings);
        this.applyNaqsPortSettings(settings);
    }

    public void updateSettings(NaqsViewSettings naqsSettings) {
        ConnectionSettings settings = naqsSettings.getConnectionSettings();
        settings.setCallback(this.isCallback());
        settings.setConnect(this.isConnect());
        settings.setNaqsHost(this.getNaqsHost());
        settings.setNaqsPort(this.getNaqsPort());
    }

    public void valueChanged(Object source) {
        if (this.updating) {
            this.needsUpdate = true;
            return;
        }
        if (this.isConnect()) {
            try {
                this.client.connectTo(this.getNaqsHost(), this.getNaqsPort(), this.isCallback());
                this.statusField.setText("connecting");
            }
            catch (UnknownHostException uhe) {
                this.statusField.setText("Unknown host");
                this.client.disconnect();
            }
        } else {
            this.client.disconnect();
            this.statusField.setText("disconnected");
        }
    }

    class ClientMonitor
    implements StatusMonitor {
        ClientMonitor() {
        }

        public void reportStatus(String state) {
            ConnectionController.this.statusField.setText(state);
        }
    }
}

