/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.MsgClient;
import ca.nanometrics.msg.StatusMonitor;
import ca.nanometrics.uitools.IntEntryField;
import ca.nanometrics.uitools.IntValidator;
import ca.nanometrics.uitools.layout.VerFlowLayout;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.Log;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectionPanel
extends JPanel {
    private JTextField userField;
    private JPasswordField pwdField;
    private JTextField dataServerHostField;
    private IntEntryField dataServerPortField;
    private JTextField naqsHostField;
    private IntEntryField naqsPortField;
    private JCheckBox connectCheck;
    private JCheckBox callbackCheck;
    protected boolean connected = false;
    private Dimension labelSize;
    private MsgClient client;
    private SohDataSource dataServerSource;
    private ConnectionMonitor connMonitor;

    public ConnectionPanel(MsgClient mClient, SohDataSource dataSource) {
        this.client = mClient;
        this.connMonitor = new ConnectionMonitor();
        this.client.setMonitor(this.connMonitor);
        this.dataServerSource = dataSource;
        this.buildPanel();
    }

    public void applySettings(NaqsViewSettings nSettings, boolean initial) {
        ConnectionSettings newSettings = nSettings.getConnectionSettings();
        this.applySettingsToFields(newSettings, initial);
    }

    private void applySettingsToFields(ConnectionSettings settings, boolean initial) {
        this.naqsHostField.setText(settings.getNaqsHost());
        this.naqsPortField.setValue(settings.getNaqsPort(), initial);
        this.dataServerHostField.setText(settings.getDataServerHost());
        this.dataServerPortField.setValue(settings.getDataServerPort(), initial);
        this.userField.setText(settings.getUserName());
        this.pwdField.setText(settings.getPassword());
        this.connectCheck.setSelected(settings.isConnect());
        this.callbackCheck.setSelected(settings.isCallback());
        this.updateConnections();
    }

    public void updateSettings(NaqsViewSettings nSettings) {
        ConnectionSettings otherSettings = nSettings.getConnectionSettings();
        ConnectionSettings localSettings = this.getWorkingSettings();
        otherSettings.applySettings(localSettings);
    }

    protected ConnectionSettings getWorkingSettings() {
        ConnectionSettings settings = new ConnectionSettings();
        String address = this.client.getAddressString();
        if (address.indexOf(":") >= 0) {
            String host = address.substring(0, address.indexOf(":"));
            try {
                InetAddress inet = InetAddress.getByName(host);
                if (host.equalsIgnoreCase(this.naqsHostField.getText())) {
                    settings.setNaqsHost(host);
                } else if (inet.getHostAddress().equalsIgnoreCase(this.naqsHostField.getText())) {
                    String str = inet.getHostAddress();
                    settings.setNaqsHost(str);
                }
            }
            catch (UnknownHostException inet) {
                // empty catch block
            }
            try {
                String portStr = address.substring(address.indexOf(":") + 1).trim();
                Integer port = new Integer(portStr);
                settings.setNaqsPort(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        settings.setConnect(this.connected);
        settings.setDataServerHost(this.dataServerSource.getHost());
        settings.setDataServerPort(this.dataServerSource.getPort());
        settings.setPassword(this.dataServerSource.getPassword());
        settings.setUserName(this.dataServerSource.getUserName());
        return settings;
    }

    protected ConnectionSettings getPanelSettings() {
        ConnectionSettings stgs = new ConnectionSettings();
        stgs.setCallback(this.callbackCheck.isSelected());
        stgs.setConnect(this.connectCheck.isSelected());
        stgs.setDataServerHost(this.dataServerHostField.getText());
        stgs.setDataServerPort(this.dataServerPortField.getValue());
        stgs.setNaqsHost(this.naqsHostField.getText());
        stgs.setNaqsPort(this.naqsPortField.getValue());
        stgs.setPassword(new String(this.pwdField.getPassword()));
        stgs.setUserName(this.userField.getText());
        return stgs;
    }

    private void buildPanel() {
        ConnectionSettings settings = this.getWorkingSettings();
        this.setLayout(new VerFlowLayout(1));
        JPanel connPanel = this.createDataServerPanel(settings);
        JPanel naqsPanel = this.createNaqsServerPanel(settings);
        this.add(naqsPanel);
        this.add(connPanel);
        JPanel checkPanel = this.createCheckBoxPanel();
        this.add(checkPanel);
    }

    private JPanel createCheckBoxPanel() {
        JPanel panel = new JPanel();
        this.connectCheck = new JCheckBox("Connect");
        this.connectCheck.setSelected(false);
        panel.add(this.connectCheck);
        this.callbackCheck = new JCheckBox("Callback Socket");
        this.callbackCheck.setSelected(false);
        panel.add(this.callbackCheck);
        JButton button = new JButton("Apply");
        button.addActionListener(new ApplyListener());
        panel.add(button);
        return panel;
    }

    private JPanel createDataServerPanel(ConnectionSettings settings) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder("Set DataServer Parameters"));
        JPanel labelPanel = new JPanel(new GridLayout(2, 1));
        JLabel userLabel = new JLabel("User Name: ");
        this.labelSize = userLabel.getPreferredSize();
        JLabel label = new JLabel("Host: ");
        labelPanel.add(label);
        labelPanel.add(userLabel);
        panel.add(labelPanel);
        JPanel fieldPanel = new JPanel(new GridLayout(2, 1));
        this.dataServerHostField = new JTextField(settings.getDataServerHost());
        this.dataServerHostField.setPreferredSize(new Dimension(100, 22));
        this.dataServerHostField.setToolTipText("Required.  Machine that DataServer is running on.");
        fieldPanel.add(this.dataServerHostField);
        this.userField = new JTextField(settings.getUserName());
        this.userField.setPreferredSize(new Dimension(100, 22));
        this.userField.setToolTipText("Required.  Retrieve from DataServer.ini file.");
        fieldPanel.add(this.userField);
        panel.add(fieldPanel);
        labelPanel = new JPanel(new GridLayout(2, 1));
        label = new JLabel("Port: ");
        label.setPreferredSize(this.labelSize);
        labelPanel.add(label);
        label = new JLabel("Password: ");
        label.setPreferredSize(this.labelSize);
        this.labelSize = label.getPreferredSize();
        labelPanel.add(label);
        panel.add(labelPanel);
        fieldPanel = new JPanel(new GridLayout(2, 1));
        this.dataServerPortField = new IntEntryField(settings.getDataServerPort());
        this.dataServerPortField.setPreferredSize(new Dimension(100, 22));
        this.dataServerPortField.setToolTipText("Required.  Retrieve from DataServer.ini file.");
        fieldPanel.add(this.dataServerPortField);
        this.pwdField = new JPasswordField(settings.getPassword());
        this.pwdField.setPreferredSize(new Dimension(100, 22));
        this.pwdField.setToolTipText("Required.  Retrieve from DataServer.ini file.");
        fieldPanel.add(this.pwdField);
        panel.add(fieldPanel);
        return panel;
    }

    private JPanel createNaqsServerPanel(ConnectionSettings settings) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder("Set NaqsServer Parameters"));
        JLabel label = new JLabel("Host: ");
        label.setPreferredSize(this.labelSize);
        panel.add(label);
        this.naqsHostField = new JTextField(settings.getNaqsHost());
        this.naqsHostField.setPreferredSize(new Dimension(100, 22));
        this.naqsHostField.setToolTipText("Required.  Machine that NaqsServer is running on.");
        panel.add(this.naqsHostField);
        label = new JLabel("Port: ");
        label.setPreferredSize(this.labelSize);
        panel.add(label);
        PortValidator portValidator = new PortValidator();
        this.naqsPortField = new IntEntryField(settings.getNaqsPort(), portValidator);
        this.naqsPortField.setPreferredSize(new Dimension(100, 22));
        this.naqsPortField.setToolTipText("Required.  Connection Manager Port from Naqs.ini file.");
        panel.add(this.naqsPortField);
        return panel;
    }

    private int getWorkingNaqsPort() {
        String str = this.client.getAddressString();
        if (str.indexOf(":") >= 0) {
            try {
                String s = str.substring(0, str.indexOf(":"));
                Integer i = new Integer(s);
                return i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 28000;
    }

    protected boolean parametersOKReport() {
        String host = this.dataServerHostField.getText();
        if ((host == null || host.trim().equals("")) && this.connectCheck.isSelected()) {
            ErrorDisplay.display("DataServer host is required for history plots.  Set to machine where DataServer is running.", "Parameters Incomplete");
            return true;
        }
        int port = this.dataServerPortField.getValue();
        if (port <= 0 || port > 60000) {
            ErrorDisplay.display("DataServer port: " + port + " is out of range for history plots.  See DataServer.ini file.", "Parameters Incomplete");
            System.out.println("port " + this.dataServerSource.getPort());
            this.dataServerPortField.setValue(this.dataServerSource.getPort());
            return true;
        }
        String userName = this.userField.getText();
        if ((userName == null || userName.trim().equals("")) && this.connectCheck.isSelected()) {
            ErrorDisplay.display("User name is required for history plots.  See DataServer.ini file.", "Parameters Incomplete");
            return true;
        }
        String password = new String(this.pwdField.getPassword());
        if ((password == null || password.trim().equals("")) && this.connectCheck.isSelected()) {
            ErrorDisplay.display("Password is required for history plots.  See DataServer.ini file.", "Parameters Incomplete");
            return true;
        }
        host = this.naqsHostField.getText();
        if ((host == null || host.trim().equals("")) && this.connectCheck.isSelected()) {
            ErrorDisplay.display("NaqsServer host is required.  Set to machine where NaqsServer is running.", "Parameters Incomplete");
            return false;
        }
        port = this.naqsPortField.getValue();
        if (port > 60000 || port <= 0) {
            ErrorDisplay.display("NaqsServer port: " + port + " is out of range.  See Connection Port in Naqs.ini file.", "Parameters Incomplete");
            this.naqsPortField.setValue(this.getWorkingNaqsPort());
            return false;
        }
        return true;
    }

    protected void firePropertyChange(String property, Object oldObject, Object newObject) {
        super.firePropertyChange(property, oldObject, newObject);
    }

    protected void updateConnections() {
        ConnectionSettings cSettings = this.getPanelSettings();
        if (cSettings.isConnect()) {
            try {
                this.client.connectTo(cSettings.getNaqsHost(), cSettings.getNaqsPort(), cSettings.isCallback());
                if (!this.connected) {
                    NaqsView.statusBar.push(0, "Connecting");
                    NaqsView.statusBar.push(1, "Connected");
                    Log.report(this, 1, 2, "Connected to Naqsserver.");
                    this.connected = true;
                }
            }
            catch (UnknownHostException uhe) {
                NaqsView.statusBar.push(0, "Unknown host");
                this.client.disconnect();
                this.connected = false;
                NaqsView.statusBar.push(1, "Not Connected");
                Log.report(this, 2, 2, "Disconnected from Naqsserver.");
            }
        } else {
            this.client.disconnect();
            if (this.connected) {
                NaqsView.statusBar.push(0, "Disconnecting");
                NaqsView.statusBar.push(1, "Not Connected");
                Log.report(this, 3, 2, "Disconnected from Naqsserver.");
                this.connected = false;
            }
        }
        if (this.client.isRunningOk()) {
            NaqsView.statusBar.pop(0);
        }
    }

    private class ApplyListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ConnectionSettings newSettings;
            ConnectionSettings oldSettings = ConnectionPanel.this.getWorkingSettings();
            if (!oldSettings.equals(newSettings = ConnectionPanel.this.getPanelSettings()) && ConnectionPanel.this.parametersOKReport()) {
                ConnectionPanel.this.updateConnections();
                ConnectionPanel.this.firePropertyChange("Connection", oldSettings, newSettings);
            }
        }
    }

    class ClientMonitor
    implements StatusMonitor {
        ClientMonitor() {
        }

        public void reportStatus(String state) {
            NaqsView.statusBar.push(0, state);
        }
    }

    private class ConnectionMonitor
    implements StatusMonitor {
        private ConnectionMonitor() {
        }

        public void reportStatus(String state) {
            if (state.indexOf("Connect failed") >= 0) {
                if (!ConnectionPanel.this.connected) {
                    return;
                }
                NaqsView.statusBar.pop(1);
                ConnectionPanel.this.connected = false;
                NaqsView.statusBar.push(1, "Not Connected");
                Log.report(this, 4, 2, "Disconnected from Naqsserver.");
            } else if (state.indexOf("Connected to") >= 0) {
                if (ConnectionPanel.this.connected) {
                    return;
                }
                NaqsView.statusBar.pop(1);
                ConnectionPanel.this.connected = true;
                NaqsView.statusBar.push(1, "Connected");
                Log.report(this, 5, 2, "Connected to Naqsserver.");
            }
        }
    }

    private class PortValidator
    implements IntValidator {
        private PortValidator() {
        }

        public boolean isValid(int value) {
            return value > 0 && value <= 60000;
        }

        public String getDescription() {
            return "Port Numbers must be > 0 and < 6000";
        }
    }
}

