/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.vmodel.BooleanModel;
import ca.nanometrics.vmodel.IntegerModel;
import ca.nanometrics.vmodel.StringModel;
import java.io.Serializable;
import java.util.Observable;

public class ConnectionSettings
extends Observable
implements Serializable {
    StringModel naqsHost;
    IntegerModel naqsPort;
    BooleanModel callback;
    BooleanModel connect;
    StringModel userName;
    StringModel password;
    StringModel dataServerHost;
    IntegerModel dataServerPort;

    public ConnectionSettings() {
        this("localhost", 28000, false, false, null, null, "localhost", 28002);
    }

    public ConnectionSettings(String hostname, int portnum, boolean doCallback, boolean doConnect, String user, String pword, String dataServer, int dataSvrPort) {
        this.naqsHost = new StringModel(hostname);
        this.naqsPort = new IntegerModel(portnum);
        this.callback = new BooleanModel(doCallback);
        this.connect = new BooleanModel(doConnect);
        this.userName = new StringModel(user);
        this.password = new StringModel(pword);
        this.dataServerHost = new StringModel(dataServer);
        this.dataServerPort = new IntegerModel(dataSvrPort);
    }

    public void applySettings(ConnectionSettings settings) {
        this.setNaqsHost(settings.getNaqsHost());
        this.setNaqsPort(settings.getNaqsPort());
        this.setCallback(settings.isCallback());
        this.setConnect(settings.isConnect());
        this.setUserName(settings.getUserName());
        this.setPassword(settings.getPassword());
        this.setDataServerHost(settings.getDataServerHost());
        this.setDataServerPort(settings.getDataServerPort());
    }

    public boolean equals(Object that) {
        if (that instanceof ConnectionSettings) {
            ConnectionSettings settings = (ConnectionSettings)that;
            return this.naqsHost.equals(settings.naqsHost) && this.naqsPort.equals(settings.naqsPort) && this.callback.equals(settings.callback) && this.connect.equals(settings.connect) && this.userName.equals(settings.userName) && this.password.equals(settings.password) && this.dataServerHost.equals(settings.dataServerHost) && this.dataServerPort.equals(settings.dataServerPort);
        }
        return false;
    }

    public StringModel getNaqsHostModel() {
        return this.naqsHost;
    }

    public IntegerModel getNaqsPortModel() {
        return this.naqsPort;
    }

    public BooleanModel getCallbackModel() {
        return this.callback;
    }

    public BooleanModel getConnectModel() {
        return this.connect;
    }

    public StringModel getUserNameModel() {
        return this.userName;
    }

    public StringModel getPasswordModel() {
        return this.password;
    }

    public StringModel getDataServerHostModel() {
        return this.dataServerHost;
    }

    public IntegerModel getDataServerPortModel() {
        return this.dataServerPort;
    }

    public String getNaqsHost() {
        return this.naqsHost.getValue();
    }

    public int getNaqsPort() {
        return this.naqsPort.getValue();
    }

    public boolean isCallback() {
        return this.callback.getValue();
    }

    public boolean isConnect() {
        return this.connect.getValue();
    }

    public String getUserName() {
        return this.userName.getValue();
    }

    public String getPassword() {
        return this.password.getValue();
    }

    public String getDataServerHost() {
        return this.dataServerHost.getValue();
    }

    public int getDataServerPort() {
        return this.dataServerPort.getValue();
    }

    public void setNaqsHost(String hostname) {
        this.naqsHost.setValue(hostname);
        this.tellObservers();
    }

    public void setNaqsPort(int portnum) {
        this.naqsPort.setValue(portnum);
        this.tellObservers();
    }

    public void setCallback(boolean doCallback) {
        this.callback.setValue(doCallback);
        this.tellObservers();
    }

    public void setConnect(boolean doConnect) {
        this.connect.setValue(doConnect);
        this.tellObservers();
    }

    public void setUserName(String user) {
        this.userName.setValue(user);
        this.tellObservers();
    }

    public void setPassword(String pword) {
        this.password.setValue(pword);
        this.tellObservers();
    }

    public void setDataServerHost(String host) {
        this.dataServerHost.setValue(host);
        this.tellObservers();
    }

    public void setDataServerPort(int port) {
        this.dataServerPort.setValue(port);
        this.tellObservers();
    }

    private void tellObservers() {
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    public boolean equalsNaqsServerSettings(ConnectionSettings conn) {
        return conn.getNaqsHost().equalsIgnoreCase(this.getNaqsHost()) && conn.getNaqsPort() == this.getNaqsPort();
    }
}

