/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.uitools.IntEntryField;
import ca.nanometrics.uitools.LocJDialog;
import ca.nanometrics.uitools.layout.VerFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CustomViewDialog
extends LocJDialog {
    protected SohBundle currentBundle = null;
    private boolean finalStatus;
    protected JCheckBox[] checkBoxes;
    private JPanel buttonPanel;
    protected boolean[] selectedCols;
    protected IntEntryField portField = null;
    protected int port;
    protected JScrollPane scrollPane = null;
    protected JComboBox comboBox;
    private ArrayList recBundles;
    private ArrayList allBundles;
    private JComboBox bundleListBox;
    protected boolean cancelled = false;
    protected boolean fixedPort = false;
    protected JCheckBox allBundleCheck;

    public CustomViewDialog(ArrayList bundleList) {
        this.setModal(true);
        if (bundleList.size() == 0) {
            this.createErrorDialog();
            return;
        }
        this.setBundles(bundleList);
        this.initializeColumnIndexes(true);
        this.initDialog();
        this.finishConstruction();
    }

    public CustomViewDialog(ArrayList list, String bundleName, ArrayList selected) {
        this.setModal(true);
        this.fixedPort = true;
        ArrayList<SohBundle> bundleList = new ArrayList<SohBundle>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            SohBundle bundle = (SohBundle)iter.next();
            String name = bundle.getName();
            if (bundle.hasPort() && bundle.getPort() >= 0) {
                name = String.valueOf(name) + "_Port" + bundle.getPort();
            }
            if (!bundleName.equalsIgnoreCase(name)) continue;
            bundleList.add(bundle);
            break;
        }
        if (bundleList.size() == 0) {
            this.createErrorDialog();
            return;
        }
        this.setBundles(bundleList);
        this.initializeColumnIndexes(selected);
        this.initDialog();
        this.comboBox.setSelectedItem(bundleName);
        this.finishConstruction();
    }

    private void createErrorDialog() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        JLabel label = new JLabel("No Active Bundles; Try Later.");
        label.setForeground(Color.red.darker());
        panel.add(label);
        content.add((Component)panel, "Center");
        panel = new JPanel();
        JButton button = new JButton("OK");
        button.addActionListener(new OkButtonAction());
        panel.add(button);
        content.add((Component)panel, "South");
        this.setLocation();
        this.setSize(new Dimension(200, 100));
        this.show();
    }

    private void setLocation() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screen.width / 6;
        int y = screen.height / 6;
        this.setLocation(x, y);
    }

    private void finishConstruction() {
        this.addWindowListener(new CloseWindowListener());
        this.pack();
        this.setLocation();
        this.setSize(new Dimension(300, 400));
        this.show();
    }

    private void setBundles(ArrayList bundleList) {
        Iterator iter = bundleList.iterator();
        this.recBundles = new ArrayList();
        while (iter.hasNext()) {
            this.recBundles.add(new BundleWrapper((SohBundle)iter.next()));
        }
        Collections.sort(this.recBundles);
        this.setCurrentBundle(((BundleWrapper)this.recBundles.get(0)).getBundle());
    }

    protected void setCurrentBundle(SohBundle bundle) {
        this.currentBundle = bundle;
    }

    protected SohBundle getCurrentBundle() {
        return this.currentBundle;
    }

    protected void initializeColumnIndexes(boolean selected) {
        this.selectedCols = new boolean[this.getCurrentBundle().getColumnCount()];
        int i = 0;
        while (i < this.selectedCols.length) {
            this.selectedCols[i] = selected;
            ++i;
        }
    }

    private void initializeColumnIndexes(ArrayList selected) {
        this.initializeColumnIndexes(false);
        Iterator iter = selected.iterator();
        while (iter.hasNext()) {
            Integer i = (Integer)iter.next();
            this.selectedCols[i.intValue()] = true;
        }
    }

    private void initDialog() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.setResizable(true);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel();
        JLabel label = new JLabel("Currently Active Bundles");
        label.setForeground(Color.red.darker());
        topPanel.add(label);
        this.allBundleCheck = new JCheckBox("Allow All Bundles");
        this.allBundleCheck.addActionListener(new AllBundleAction());
        topPanel.add(this.allBundleCheck);
        panel.add((Component)topPanel, "North");
        this.comboBox = this.createComboBox();
        panel.add((Component)this.comboBox, "South");
        pane.add((Component)panel, "North");
        this.createCentralPanel();
        pane.add((Component)this.scrollPane, "Center");
        this.buttonPanel = this.createButtonPanel();
        pane.add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private JComboBox createComboBox() {
        this.bundleListBox = new JComboBox();
        this.bundleListBox.addActionListener(new ComboBoxListener());
        this.updateComboBox();
        return this.bundleListBox;
    }

    protected void updateComboBox() {
        Object[] bundleStrings = this.getBundleStrings();
        this.bundleListBox.removeAllItems();
        int i = 0;
        while (i < bundleStrings.length) {
            this.bundleListBox.addItem(bundleStrings[i]);
            ++i;
        }
    }

    protected ArrayList getBundleWrappers() {
        ArrayList bundles = null;
        bundles = this.allBundleCheck.isSelected() ? this.allBundles : this.recBundles;
        if (bundles == null) {
            this.allBundles = new ArrayList();
            ArrayList all = SohBundleFactory.getBundleList();
            int i = 0;
            while (i < all.size()) {
                SohBundle bundle = (SohBundle)all.get(i);
                int type = bundle.getType();
                if (type != 0 && type != 10 && type != 11 && type != 12 && type != 24 && type != 45 && type != 46 && type != 50 && type != 51 && type != 67) {
                    BundleWrapper w = new BundleWrapper(bundle);
                    this.allBundles.add(w);
                }
                ++i;
            }
            bundles = this.allBundles;
        }
        return bundles;
    }

    private Object[] getBundleStrings() {
        ArrayList list = this.getBundleWrappers();
        Object[] strs = new Object[list.size()];
        int i = 0;
        while (i < strs.length) {
            BundleWrapper bw = (BundleWrapper)list.get(i);
            SohBundle b = bw.getBundle();
            strs[i] = String.valueOf(b.getName()) + "  (*" + b.getCsvName() + ")";
            ++i;
        }
        return strs;
    }

    protected void createCentralPanel() {
        if (this.scrollPane != null) {
            this.getContentPane().remove(this.scrollPane);
        }
        JPanel panel = new JPanel(new VerFlowLayout());
        JLabel label = new JLabel("Choose columns to show");
        label.setForeground(Color.red.darker());
        panel.add(label);
        JPanel colChoice = this.createColumnChoicePanel();
        panel.add(colChoice);
        if (this.getCurrentBundle().hasPort()) {
            JPanel portPanel = this.createPortPanel();
            portPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            panel.add(portPanel);
        }
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel.setPreferredSize(new Dimension(0, (int)panel.getPreferredSize().getHeight()));
        this.scrollPane = new JScrollPane(panel, 20, 31);
    }

    private JPanel createPortPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        this.portField = new IntEntryField(0);
        this.portField.setValue(this.getCurrentBundle().getPort());
        this.portField.setPreferredSize(new Dimension(22, 20));
        if (this.fixedPort) {
            this.portField.setEnabled(false);
        }
        panel.add(this.portField);
        JLabel label = new JLabel("Port Number");
        panel.add(label);
        return panel;
    }

    private JPanel createColumnChoicePanel() {
        JPanel panel = new JPanel();
        SohBundle bundle = this.getCurrentBundle();
        if (bundle == null) {
            return panel;
        }
        JPanel checkBoxPanel = new JPanel(new GridLayout(bundle.getColumnCount(), 1));
        this.checkBoxes = new JCheckBox[bundle.getColumnCount()];
        int i = 0;
        while (i < bundle.getColumnCount()) {
            this.checkBoxes[i] = new JCheckBox(bundle.getReadingHeaderByIndex(i));
            this.checkBoxes[i].setSelected(this.selectedCols[i]);
            if (bundle.getDataTypeByIndex(i).equals("time") || bundle.getDataTypeByIndex(i).equals("formattedTime")) {
                this.checkBoxes[i].setSelected(false);
            } else {
                checkBoxPanel.add(this.checkBoxes[i]);
            }
            ++i;
        }
        panel.add(checkBoxPanel);
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Ok");
        button.setPreferredSize(new Dimension(100, 30));
        button.addActionListener(new OkButtonAction());
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.setPreferredSize(new Dimension(100, 30));
        button.addActionListener(new CancelButtonAction());
        buttonPanel.add(button);
        return buttonPanel;
    }

    protected void dispose(boolean success) {
        this.finalStatus = success;
        super.dispose(success);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public boolean getSuccess() {
        return this.finalStatus;
    }

    public SohBundle getSelectedBundle() {
        int index = this.comboBox.getSelectedIndex();
        BundleWrapper wrapper = (BundleWrapper)this.getBundleWrappers().get(index);
        return wrapper.getBundle();
    }

    protected boolean parametersOK() {
        return true;
    }

    public ArrayList getSelectedColumns() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.selectedCols.length) {
            if (this.selectedCols[i]) {
                list.add(new Integer(i));
            }
            ++i;
        }
        return list;
    }

    public int getPort() {
        return this.port;
    }

    class AllBundleAction
    implements ActionListener {
        AllBundleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CustomViewDialog.this.updateComboBox();
        }
    }

    class BundleWrapper
    implements Comparable {
        SohBundle bundle;

        public BundleWrapper(SohBundle bdl) {
            this.bundle = bdl;
        }

        public int compareTo(Object o) {
            if (!(o instanceof BundleWrapper)) {
                return -1;
            }
            BundleWrapper other = (BundleWrapper)o;
            return this.getName().compareTo(other.getName());
        }

        public SohBundle getBundle() {
            return this.bundle;
        }

        protected String getName() {
            return this.bundle.getName();
        }
    }

    class CancelButtonAction
    implements ActionListener {
        CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CustomViewDialog.this.cancelled = true;
            CustomViewDialog.this.dispose(false);
        }
    }

    class CloseWindowListener
    implements WindowListener {
        CloseWindowListener() {
        }

        public void windowClosing(WindowEvent arg0) {
            CustomViewDialog.this.cancelled = true;
        }

        public void windowActivated(WindowEvent arg0) {
        }

        public void windowClosed(WindowEvent arg0) {
        }

        public void windowDeactivated(WindowEvent arg0) {
        }

        public void windowDeiconified(WindowEvent arg0) {
        }

        public void windowIconified(WindowEvent arg0) {
        }

        public void windowOpened(WindowEvent arg0) {
        }
    }

    class ComboBoxListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (CustomViewDialog.this.comboBox == null) {
                return;
            }
            int choice = CustomViewDialog.this.comboBox.getSelectedIndex();
            if (choice < 0) {
                return;
            }
            ArrayList bundles = CustomViewDialog.this.getBundleWrappers();
            BundleWrapper wrap = (BundleWrapper)bundles.get(choice);
            SohBundle bndl = wrap.getBundle();
            if (CustomViewDialog.this.getCurrentBundle() == bndl) {
                return;
            }
            CustomViewDialog.this.setCurrentBundle(bndl);
            CustomViewDialog.this.initializeColumnIndexes(true);
            CustomViewDialog.this.createCentralPanel();
            CustomViewDialog.this.getContentPane().add((Component)CustomViewDialog.this.scrollPane, "Center");
            CustomViewDialog.this.pack();
        }
    }

    class OkButtonAction
    implements ActionListener {
        OkButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CustomViewDialog.this.scrollPane == null) {
                CustomViewDialog.this.dispose(false);
                return;
            }
            if (CustomViewDialog.this.parametersOK()) {
                int i = 0;
                while (i < CustomViewDialog.this.selectedCols.length) {
                    CustomViewDialog.this.selectedCols[i] = CustomViewDialog.this.checkBoxes[i].isSelected();
                    ++i;
                }
                if (CustomViewDialog.this.portField != null) {
                    CustomViewDialog.this.port = CustomViewDialog.this.portField.getValue();
                }
                CustomViewDialog.this.dispose(true);
            }
        }
    }
}

