/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.LibraEnvironSohBundle;
import ca.nanometrics.bundle.SlowExternalSohBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.SimpleTableCellRenderer;
import ca.nanometrics.util.InvalidInputException;
import javax.swing.table.TableCellRenderer;

public class ExternalSohTableRow
extends AbstractSohTableRow {
    protected static String tableName = "Environmental State of Health";
    private int[] bundleTypes = new int[]{49, 33};
    public static final int COLUMN_COUNT = 6;
    public static final int STATION_NAME = 0;
    public static final int INSTRUMENT = 1;
    public static final int LAST_UPDATE = 2;
    public static final int SOHCHAN1 = 3;
    public static final int SOHCHAN2 = 4;
    public static final int SOHCHAN3 = 5;
    protected long lastUpdate = 0L;
    protected float sohChan1 = 0.0f;
    protected float sohChan2 = 0.0f;
    protected float sohChan3 = 0.0f;
    protected DoubleColorNode sohNode1;
    protected DoubleColorNode sohNode2;
    protected DoubleColorNode sohNode3;
    protected GradingThresholds gt1;
    protected GradingThresholds gt2;
    protected GradingThresholds gt3;
    protected StationNode stationNode;
    protected boolean hasCC = false;
    private SohDataSource dataSource;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ExternalSohTableRow(int theKey, String theStation) {
        super(theKey, theStation);
        this.createThresholds();
    }

    public SohTableRow createTableRow(int key, String name) {
        ExternalSohTableRow row = new ExternalSohTableRow(key, name);
        row.setDataSource(this.getDataSource());
        row.setThresholds(this.getThresholds(1), 1);
        row.setThresholds(this.getThresholds(2), 2);
        row.setThresholds(this.getThresholds(3), 3);
        int id = ChannelKey.getIDOf(key);
        row.hasCC = Instrument.isController(id);
        return row;
    }

    private void createThresholds() {
        this.gt1 = new GradingThresholds(-3.0, -2.0, 2.0, 3.0);
        this.gt2 = new GradingThresholds(-15.0, -10.0, 10.0, 15.0);
        this.gt3 = new GradingThresholds(-15.0, -10.0, 10.0, 15.0);
    }

    public void applyThresholds(GradingThresholdTable table) {
        GradingThresholds gt = table.get("Channel 1");
        if (gt != null) {
            this.getThresholds(1).setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
        if ((gt = table.get("Channel 2")) != null) {
            this.getThresholds(2).setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
        if ((gt = table.get("Channel 3")) != null) {
            this.getThresholds(3).setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
    }

    private DoubleColorNode getSohNode(int i) {
        switch (i) {
            case 1: {
                if (this.sohNode1 == null) {
                    this.createSohNode(1);
                }
                return this.sohNode1;
            }
            case 2: {
                if (this.sohNode2 == null) {
                    this.createSohNode(2);
                }
                return this.sohNode2;
            }
            case 3: {
                if (this.sohNode3 == null) {
                    this.createSohNode(3);
                }
                return this.sohNode3;
            }
        }
        return null;
    }

    private void createSohNode(int i) {
        DoubleColorNode node = null;
        switch (i) {
            case 1: {
                node = this.sohNode1;
                break;
            }
            case 2: {
                node = this.sohNode2;
                break;
            }
            case 3: {
                node = this.sohNode3;
                break;
            }
            default: {
                System.out.println("Node not created");
            }
        }
        if (node != null) {
            return;
        }
        node = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Soh" + i, this.bundleType, this.bundleTypes, "%0.2f", this.dataSource, 2);
        node.setThresholds(this.getThresholds(i));
        switch (i) {
            case 1: {
                this.sohNode1 = node;
                break;
            }
            case 2: {
                this.sohNode2 = node;
                break;
            }
            case 3: {
                this.sohNode3 = node;
                break;
            }
            default: {
                System.out.println("Node not created");
            }
        }
    }

    private void setThresholds(GradingThresholds gt, int i) {
        switch (i) {
            case 1: {
                this.gt1 = gt;
                this.getSohNode(1).setThresholds(this.gt1);
                return;
            }
            case 2: {
                this.gt2 = gt;
                this.getSohNode(2).setThresholds(this.gt2);
                return;
            }
            case 3: {
                this.gt3 = gt;
                this.getSohNode(3).setThresholds(this.gt3);
                return;
            }
        }
    }

    private GradingThresholds getThresholds(int i) {
        switch (i) {
            case 1: {
                return this.gt1;
            }
            case 2: {
                return this.gt2;
            }
            case 3: {
                return this.gt3;
            }
        }
        return null;
    }

    public void setDataSource(SohDataSource source) {
        this.dataSource = source;
        int i = 1;
        while (i < 4) {
            this.getSohNode(i).setDataSource(this.dataSource);
            ++i;
        }
    }

    public SohDataSource getDataSource() {
        return this.dataSource;
    }

    public String getTableName() {
        String str = NmxHelp.getFieldName("esoh.title");
        if (str != null && str.trim().length() > 0) {
            return str;
        }
        return tableName;
    }

    public boolean acceptKey(int key) {
        int model = ChannelKey.getModelOf(key);
        return ChannelKey.getTypeOf(key) == 2 && model != 2;
    }

    private void setNodeNamesAndIndexes(SohBundle bundle) {
        int index = 0;
        int i = 1;
        while (i <= bundle.getColumnCount()) {
            String newStr = bundle.getReadingHeaderByIndex(i);
            if (newStr.indexOf("1") >= 0) {
                index = 1;
            } else if (newStr.indexOf("2") >= 0) {
                index = 2;
            } else if (newStr.indexOf("3") >= 0) {
                index = 3;
            }
            if (index != 0 && newStr.length() > 0) {
                this.getSohNode(index).setReadingName(newStr);
                this.getSohNode(index).setReadingDataIndex(i);
            }
            ++i;
        }
    }

    private void updateNodes() {
        this.getDateNode().setCurrentTime(this.lastUpdate);
        this.getSohNode(1).setCurrentValues(this.sohChan1, this.lastUpdate);
        this.getSohNode(2).setCurrentValues(this.sohChan2, this.lastUpdate);
        this.getSohNode(3).setCurrentValues(this.sohChan3, this.lastUpdate);
    }

    public void process(SohBundle bundle) throws InvalidInputException {
        if (bundle.getType() == 49) {
            if (!this.hasCC) {
                return;
            }
            LibraEnvironSohBundle sesb = new LibraEnvironSohBundle(bundle);
            this.lastUpdate = sesb.getLongSeconds();
            this.sohChan1 = sesb.getExtSoh1();
            this.sohChan2 = sesb.getExtSoh2();
            this.sohChan3 = sesb.getExtSoh3();
            this.setNodeNamesAndIndexes(sesb);
            this.bundleType = 49;
            int i = 1;
            while (i < 4) {
                this.getSohNode(i).setBundleType(this.bundleType);
                ++i;
            }
            this.updateNodes();
            this.setChanged();
            this.notifyObservers();
        } else if (!this.hasCC && bundle.getType() == 33) {
            SlowExternalSohBundle sesb = new SlowExternalSohBundle(bundle);
            this.lastUpdate = sesb.getLongSeconds();
            this.sohChan1 = sesb.getSoh1();
            this.sohChan2 = sesb.getSoh2();
            this.sohChan3 = sesb.getSoh3();
            this.setNodeNamesAndIndexes(sesb);
            this.bundleType = 33;
            int i = 1;
            while (i < 4) {
                this.getSohNode(i).setBundleType(this.bundleType);
                ++i;
            }
            this.updateNodes();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean hasPopup(int col) {
        return col == 3 || col == 4 || col == 5;
    }

    public void resetNode(int col) {
        switch (col) {
            case 3: {
                this.getSohNode(1).reset();
                break;
            }
            case 4: {
                this.getSohNode(2).reset();
                break;
            }
            case 5: {
                this.getSohNode(3).reset();
            }
        }
    }

    public void resetAll() {
        this.resetNode(3);
        this.resetNode(4);
        this.resetNode(5);
    }

    public DoubleNode getDoubleNode(int col) {
        switch (col) {
            case 3: {
                return this.getSohNode(1);
            }
            case 4: {
                return this.getSohNode(2);
            }
            case 5: {
                return this.getSohNode(3);
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NmxHelp.getFieldName("station");
            }
            case 1: {
                return NmxHelp.getFieldName("instrument");
            }
            case 2: {
                return NmxHelp.getFieldName("lastupdate");
            }
            case 3: {
                return NmxHelp.getFieldName("esoh.channel1");
            }
            case 4: {
                return NmxHelp.getFieldName("esoh.channel2");
            }
            case 5: {
                return NmxHelp.getFieldName("esoh.channel3");
            }
        }
        return "Invalid";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("StationNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("DateNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        return null;
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new SimpleTableCellRenderer();
            }
            case 1: {
                return new SimpleTableCellRenderer();
            }
            case 2: {
                return new GradedDateSecTableCellRenderer(new GradingThresholds(-30.0, -10.0, 120.0, 600.0));
            }
            case 3: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(-3.0, -2.0, 2.0, 3.0));
            }
            case 4: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(-15.0, -10.0, 10.0, 15.0));
            }
            case 5: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(-15.0, -10.0, 10.0, 15.0));
            }
        }
        return null;
    }

    private StationNode getStationNode() {
        if (this.stationNode == null) {
            this.stationNode = new StationNode(this.getStationName(), this.getChannelName(), this.getInstrument());
            this.stationNode.addNode(this.getSohNode(1));
            this.stationNode.addNode(this.getSohNode(2));
            this.stationNode.addNode(this.getSohNode(3));
        }
        return this.stationNode;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getStationNode();
            }
            case 1: {
                return this.getInstrument();
            }
            case 2: {
                DateNode dNode = this.getDateNode();
                dNode.setCurrentTime(this.lastUpdate);
                return dNode;
            }
            case 3: {
                DoubleColorNode node = this.getSohNode(1);
                node.setCurrentValues(this.sohChan1, this.lastUpdate);
                return node;
            }
            case 4: {
                DoubleColorNode node = this.getSohNode(2);
                node.setCurrentValues(this.sohChan2, this.lastUpdate);
                return node;
            }
            case 5: {
                DoubleColorNode node = this.getSohNode(3);
                node.setCurrentValues(this.sohChan3, this.lastUpdate);
                return node;
            }
        }
        return null;
    }

    public int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 80;
            }
            case 1: {
                return 60;
            }
            case 2: {
                return 120;
            }
            case 3: {
                return 60;
            }
            case 4: {
                return 60;
            }
            case 5: {
                return 60;
            }
        }
        return 80;
    }

    public void setValueAt(Object aValue, int columnIndex) {
    }

    public boolean isCellEditable(int columnIndex) {
        return false;
    }
}

