/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JTable;

public class GradedDateSecTableCellRenderer
extends GradedTableCellRenderer {
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public GradedDateSecTableCellRenderer(GradingThresholds gtt) {
        super(gtt);
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.setBackground(this.defaultBG);
            this.textLabel.setText("");
        } else if (value instanceof Number) {
            long millis = 1000L * ((Number)value).longValue();
            this.setDateCell(millis);
        } else if (value instanceof DateNode) {
            DateNode node = (DateNode)value;
            this.setDateCell(1000L * node.getCurrentTime());
        } else {
            this.setBackground(this.defaultBG);
            this.textLabel.setText(value.toString());
        }
        return this;
    }

    private void setDateCell(long millis) {
        long current = System.currentTimeMillis();
        this.setCellBackground(0.001 * (double)(current - millis));
        this.textLabel.setText(this.dateFormatter.format(new Date(millis)));
    }
}

