/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.DateEntryField;
import ca.nanometrics.uitools.DoubleEntryField;
import ca.nanometrics.uitools.TimeEntryField;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.NmxDateFormat;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HistoryDurationDialog
extends JDialog {
    protected DateEntryField dateField;
    protected TimeEntryField timeField;
    private JComboBox unitsBox;
    private DoubleEntryField durationField;
    private Checkbox startTimeCheck;
    protected Checkbox mostRecentCheck;
    protected CheckboxGroup checkboxGroup;
    private DoubleNode node;
    protected HistoryDuration data;
    private boolean finalStatus = false;
    private static final int SECONDS_INDEX = 0;
    private static final int MINUTES_INDEX = 1;
    private static final int HOURS_INDEX = 2;
    private static final int DAYS_INDEX = 3;
    private static final String SECONDS = "Seconds";
    private static final String MINUTES = "Minutes";
    private static final String HOURS = "Hours";
    private static final String DAYS = "Days";
    private static final String START_TIME = "From Start Time";
    private static final String MOST_RECENT_TIME = "Most Recent";

    public HistoryDurationDialog(DoubleNode aNode) throws IOException {
        this.setModal(true);
        this.node = aNode;
        this.setTitle(this.node.getStationName());
        double minTime = this.node.getMinDataServerTime();
        double maxTime = this.node.getMaxDataServerTime();
        this.data = new HistoryDuration(minTime, maxTime - minTime, minTime, maxTime);
        this.finishConstruction();
    }

    public HistoryDurationDialog(double start, double duration) throws IOException {
        this.setModal(true);
        this.data = new HistoryDuration(start, duration, start, System.currentTimeMillis() / 1000L);
        this.node = null;
        this.finishConstruction();
    }

    private void finishConstruction() {
        this.initDialog();
        this.applySettings();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screen.width / 6;
        int y = screen.height / 6;
        this.setLocation(x, y);
        this.setSize(new Dimension(400, 200));
        this.show();
    }

    public double getStartTime() {
        return this.data.getStartTime();
    }

    public double getDuration() {
        return this.data.getDuration();
    }

    private int getSelectedUnitsIndex(String units) {
        if (units.equalsIgnoreCase(SECONDS)) {
            return 0;
        }
        if (units.equalsIgnoreCase(MINUTES)) {
            return 1;
        }
        if (units.equalsIgnoreCase(HOURS)) {
            return 2;
        }
        if (units.equalsIgnoreCase(DAYS)) {
            return 3;
        }
        return 0;
    }

    private void applySettings() {
        double dur;
        PlotSettings settings = HistoryViewer.getPlotSettings();
        if (settings == null) {
            double start = this.data.getStartTime();
            this.timeField.setValue(start);
            this.dateField.setValue(start);
            double dur2 = this.data.getDuration();
            this.durationField.setValue(dur2);
            return;
        }
        if (settings.getMostRecent()) {
            this.checkboxGroup.setSelectedCheckbox(this.mostRecentCheck);
        }
        int index = this.getSelectedUnitsIndex(settings.getUnitString());
        if (!settings.getUnitString().equalsIgnoreCase(SECONDS)) {
            this.unitsBox.setSelectedIndex(this.getSelectedUnitsIndex(settings.getUnitString()));
        }
        if ((dur = settings.getDuration()) == 0.0) {
            dur = this.data.getDuration();
        }
        switch (index) {
            case 3: {
                dur /= 24.0;
            }
            case 2: {
                dur /= 60.0;
            }
            case 1: {
                dur /= 60.0;
            }
        }
        this.durationField.setValue(dur);
        if (this.checkboxGroup.getSelectedCheckbox() == this.mostRecentCheck) {
            this.updateTimesFromDuration();
        } else {
            double start = settings.getStartTime();
            if (start == 0.0) {
                start = this.data.getStartTime();
            }
            this.timeField.setValue(start);
            this.dateField.setValue(start);
        }
    }

    protected double getDurationInSeconds() {
        double retVal = this.durationField.getValue();
        switch (this.unitsBox.getSelectedIndex()) {
            case 3: {
                retVal *= 24.0;
            }
            case 2: {
                retVal *= 60.0;
            }
            case 1: {
                retVal *= 60.0;
            }
        }
        return retVal;
    }

    private String getTimeAvailableText() {
        if (this.node == null) {
            return null;
        }
        NmxDateFormat format = new NmxDateFormat();
        return "Time Available: " + format.format(this.data.getTimeAvailableStart()) + " to " + format.format(this.data.getTimeAvailableEnd());
    }

    private void initDialog() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.setResizable(true);
        String text = this.getTimeAvailableText();
        if (text != null) {
            JTextField label = new JTextField(text);
            label.setForeground(Color.red.darker());
            label.setEditable(false);
            pane.add((Component)label, "North");
        }
        JPanel timePanel = this.createTimeAndDurationPanel();
        pane.add((Component)timePanel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        pane.add((Component)buttonPanel, "South");
        this.pack();
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Ok");
        button.setPreferredSize(new Dimension(100, 30));
        button.addActionListener(new OkButtonAction());
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.setPreferredSize(new Dimension(100, 30));
        button.addActionListener(new CancelButtonAction());
        buttonPanel.add(button);
        return buttonPanel;
    }

    private JPanel createTimeAndDurationPanel() {
        JPanel timePanel = new JPanel(new GridLayout(2, 4, 10, 0));
        this.dateField = new DateEntryField(0.0);
        this.dateField.addActionListener(new TimesActionListener());
        this.dateField.addFocusListener(new TimesFocusListener());
        this.timeField = new TimeEntryField(0.0);
        this.timeField.addActionListener(new TimesActionListener());
        this.timeField.addFocusListener(new TimesFocusListener());
        this.durationField = new DoubleEntryField(0.0);
        this.durationField.addActionListener(new DurationActionListener());
        this.durationField.addFocusListener(new DurationFocusListener());
        Vector<String> units = new Vector<String>();
        units.add(SECONDS);
        units.add(MINUTES);
        units.add(HOURS);
        units.add(DAYS);
        this.unitsBox = new JComboBox(units);
        this.unitsBox.addActionListener(new DurationActionListener());
        timePanel.add(new JLabel("Start Date"));
        timePanel.add(new JLabel("Start Time"));
        timePanel.add(new JLabel("Duration"));
        timePanel.add(new JLabel(""));
        timePanel.add(this.dateField);
        timePanel.add(this.timeField);
        timePanel.add(this.durationField);
        timePanel.add(this.unitsBox);
        JPanel cBoxPanel = this.getTimeTypeBox();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Set History Time Interval"));
        panel.add((Component)timePanel, "North");
        panel.add((Component)cBoxPanel, "South");
        return panel;
    }

    private JPanel getTimeTypeBox() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.checkboxGroup = new CheckboxGroup();
        this.startTimeCheck = new Checkbox(START_TIME, this.checkboxGroup, true);
        this.startTimeCheck.addItemListener(new CheckboxListener());
        panel.add(this.startTimeCheck);
        this.mostRecentCheck = new Checkbox(MOST_RECENT_TIME, this.checkboxGroup, false);
        this.mostRecentCheck.addItemListener(new CheckboxListener());
        panel.add(this.mostRecentCheck);
        return panel;
    }

    protected void dispose(boolean success) {
        this.finalStatus = success;
        super.dispose();
    }

    public boolean getSuccess() {
        return this.finalStatus;
    }

    protected void updateTimesFromDuration() {
        double dur = this.getDurationInSeconds();
        if (this.checkboxGroup.getSelectedCheckbox() == this.mostRecentCheck) {
            double value = this.data.getTimeAvailableEnd() - dur;
            this.dateField.setValue(value);
            this.timeField.setValue(value);
        }
    }

    protected void updateDurationFromTimes() {
        if (this.checkboxGroup.getSelectedCheckbox() == this.mostRecentCheck) {
            double startVal = this.dateField.getValue() + this.timeField.getValue();
            double duration = this.data.getTimeAvailableEnd() - startVal;
            if (duration < 0.0) {
                duration = 0.0;
            }
            this.setValueToDurationField(duration);
        }
    }

    private void setValueToDurationField(double secs) {
        int index = this.unitsBox.getSelectedIndex();
        double val = secs;
        switch (index) {
            case 1: {
                val /= 60.0;
                break;
            }
            case 3: {
                val /= 24.0;
            }
            case 2: {
                val /= 3600.0;
            }
        }
        this.durationField.setValue(val);
    }

    protected boolean parametersOK() {
        if (this.data.getDuration() <= 0.0) {
            ErrorDisplay.display("Duration must be greater than zero.", "Parameters Incomplete");
            return false;
        }
        return true;
    }

    protected void updatePlotSettings() {
        PlotSettings settings = HistoryViewer.getPlotSettings();
        settings.setStartTime(this.data.getStartTime());
        settings.setDuration(this.data.getDuration());
        settings.setUnitsString((String)this.unitsBox.getSelectedItem());
        if (this.checkboxGroup.getSelectedCheckbox() == this.mostRecentCheck) {
            settings.setMostRecent(true);
        } else {
            settings.setMostRecent(false);
        }
    }

    class CancelButtonAction
    implements ActionListener {
        CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HistoryDurationDialog.this.dispose(false);
        }
    }

    class CheckboxListener
    implements ItemListener {
        CheckboxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (HistoryDurationDialog.this.checkboxGroup.getSelectedCheckbox() == HistoryDurationDialog.this.mostRecentCheck) {
                HistoryDurationDialog.this.updateTimesFromDuration();
            }
        }
    }

    class DurationActionListener
    implements ActionListener {
        DurationActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            HistoryDurationDialog.this.updateTimesFromDuration();
        }
    }

    class DurationFocusListener
    implements FocusListener {
        DurationFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            HistoryDurationDialog.this.updateTimesFromDuration();
        }
    }

    private class HistoryDuration {
        private double startTime;
        private double duration;
        private double timeAvailableStart;
        private double timeAvailableEnd;

        HistoryDuration(double start, double dur, double timeAvailStart, double timeAvailEnd) {
            this.startTime = start;
            this.duration = dur;
            this.timeAvailableStart = timeAvailStart;
            this.timeAvailableEnd = timeAvailEnd;
        }

        public void resetValues(double start, double dur) {
            this.startTime = start;
            this.duration = dur;
        }

        public double getStartTime() {
            return this.startTime;
        }

        public double getEndTime() {
            return this.startTime + this.duration;
        }

        public double getDuration() {
            return this.duration;
        }

        public double getTimeAvailableStart() {
            return this.timeAvailableStart;
        }

        public double getTimeAvailableEnd() {
            return this.timeAvailableEnd;
        }
    }

    class OkButtonAction
    implements ActionListener {
        OkButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            double startTime = HistoryDurationDialog.this.dateField.getValue() + HistoryDurationDialog.this.timeField.getValue();
            double duration = HistoryDurationDialog.this.getDurationInSeconds();
            HistoryDurationDialog.this.data.resetValues(startTime, duration);
            if (HistoryDurationDialog.this.parametersOK()) {
                HistoryDurationDialog.this.updatePlotSettings();
                HistoryDurationDialog.this.dispose(true);
            }
        }
    }

    class TimesActionListener
    implements ActionListener {
        TimesActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            HistoryDurationDialog.this.updateDurationFromTimes();
        }
    }

    class TimesFocusListener
    implements FocusListener {
        TimesFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            HistoryDurationDialog.this.updateDurationFromTimes();
        }
    }
}

