/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.LocJDialog;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.NmxDateFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HistoryReportDialog
extends LocJDialog {
    private DoubleNode node;

    public HistoryReportDialog(DoubleNode aNode) {
        this.setModal(false);
        this.node = aNode;
        this.setTitle(this.node.getName());
        this.initDialog();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screen.width / 6;
        int y = screen.height / 6;
        this.setLocation(x, y);
        this.setSize(new Dimension(400, 200));
        this.show();
    }

    private void initDialog() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.setResizable(true);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Parameter: " + this.node.getReadingName());
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "North");
        JPanel dataPanel = this.createDataPanel();
        panel.add((Component)dataPanel, "Center");
        NmxDateFormat dFmt = new NmxDateFormat();
        String dateStr = dFmt.format(this.node.getInitialTime());
        label = new JLabel("Time stamp of first packet or last reset: " + dateStr);
        panel.add((Component)label, "South");
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        pane.add((Component)panel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        pane.add((Component)buttonPanel, "South");
        this.pack();
    }

    private JPanel createColumn1() {
        JPanel panel = new JPanel(new GridLayout(4, 1));
        panel.add(new JLabel(""));
        panel.add(new JLabel("Current: "));
        panel.add(new JLabel("Minimum: "));
        panel.add(new JLabel("Maximum: "));
        return panel;
    }

    private JPanel createColumn2() {
        JPanel panel = new JPanel(new GridLayout(4, 1));
        NmxDateFormat dFmt = new NmxDateFormat();
        panel.add(new JLabel("Time"));
        JTextField field = new JTextField(dFmt.format(this.node.getCurrentTime()));
        field.setEditable(false);
        panel.add(field);
        field = new JTextField(dFmt.format(this.node.getMinValueTime()));
        field.setEditable(false);
        panel.add(field);
        field = new JTextField(dFmt.format(this.node.getMaxValueTime()));
        field.setEditable(false);
        panel.add(field);
        return panel;
    }

    private JPanel createColumn3() {
        JPanel panel = new JPanel(new GridLayout(4, 1));
        Format fmt = new Format("%0.2f");
        panel.add(new JLabel("Value"));
        JTextField field = new JTextField(fmt.form(this.node.getCurrentValue()));
        field.setEditable(false);
        panel.add(field);
        field = new JTextField(fmt.form(this.node.getMinValue()));
        field.setEditable(false);
        panel.add(field);
        field = new JTextField(fmt.form(this.node.getMaxValue()));
        field.setEditable(false);
        panel.add(field);
        return panel;
    }

    private JPanel createDataPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 10));
        panel.add(this.createColumn1());
        panel.add(this.createColumn2());
        panel.add(this.createColumn3());
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Ok");
        button.setPreferredSize(new Dimension(100, 30));
        button.addActionListener(new OkButtonAction());
        buttonPanel.add(button);
        return buttonPanel;
    }

    protected void dispose(boolean success) {
        super.dispose(success);
    }

    class OkButtonAction
    implements ActionListener {
        OkButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HistoryReportDialog.this.dispose(true);
        }
    }
}

