/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.LibraGpsTimeQualityBundle;
import ca.nanometrics.bundle.LibraSystemTimeQualityBundle;
import ca.nanometrics.bundle.RockwellGpsSatelliteBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.VcxoCalibrationBundle;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.SimpleTableCellRenderer;
import ca.nanometrics.util.InvalidInputException;
import java.util.Enumeration;
import javax.swing.table.TableCellRenderer;

public class InstrumentGpsTableRow
extends AbstractSohTableRow {
    public static String tableName = "Instrument GPS";
    public final int[] numSatBundleTypes = new int[]{54, 15};
    public final int[] pdopBundleTypes = new int[]{54};
    public final int[] tdopBundleTypes = new int[]{54};
    public final int[] maxRatioBundleTypes = new int[]{15};
    public final int[] timeErrBundleTypes = new int[]{55, 7};
    public static final int COLUMN_COUNT = 10;
    public static final int STATION_NAME = 0;
    public static final int INSTRUMENT = 1;
    public static final int LAST_UPDATE = 2;
    public static final int PLLMODE = 3;
    public static final int GPSSTAT = 4;
    public static final int SYSTEM_TQ = 5;
    public static final int NUMSAT = 6;
    public static final int PDOP = 7;
    public static final int TDOP = 8;
    public static final int MAX_SNRATIO = 9;
    private long lastUpdate = 0L;
    private String gpsState = "unknown";
    private String pllState = "unknown";
    private int systemTQ = 0;
    private int numSat = 0;
    private float pdop = 0.0f;
    private float tdop = 0.0f;
    private int maxSNRatio = 0;
    StationNode stationNode;
    DateNode dateNode;
    DoubleColorNode timeErrNode;
    DoubleColorNode numSatNode;
    DoubleColorNode pdopNode;
    DoubleColorNode tdopNode;
    DoubleColorNode maxRatioNode;
    StringNode gpsStatusNode;
    StringNode pllStatusNode;
    GradingThresholds timeErrGT;
    GradingThresholds numSatGT;
    GradingThresholds pdopGT;
    GradingThresholds tdopGT;
    GradingThresholds maxRatioGT;
    private boolean isRockwell = true;
    private SohDataSource dataSource;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public InstrumentGpsTableRow(int theKey, String theStation) {
        super(theKey, theStation);
        this.createThresholds();
    }

    public SohTableRow createTableRow(int key, String name) {
        InstrumentGpsTableRow row = new InstrumentGpsTableRow(key, name);
        row.setDataSource(this.getDataSource());
        row.setTimeErrorThresholds(this.getTimeErrorThresholds());
        row.setNumSatThresholds(this.getNumSatThresholds());
        row.setPDOPThresholds(this.getPDOPThresholds());
        row.setTDOPThresholds(this.getTDOPThresholds());
        row.setMaxRatioThresholds(this.getMaxRatioThresholds());
        return row;
    }

    private void createThresholds() {
        this.timeErrGT = new GradingThresholds(0.0, 0.0, 300.0, 1000.0);
        this.numSatGT = new GradingThresholds(1.0, 4.0, 80.0, 100.0);
        this.pdopGT = new GradingThresholds(0.0, 0.0, 5.0, 8.0);
        this.tdopGT = new GradingThresholds(0.0, 0.0, 5.0, 8.0);
        this.maxRatioGT = new GradingThresholds(25.0, 35.0, 100.0, 100.0);
    }

    public void applyThresholds(GradingThresholdTable table) {
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            GradingThresholds gt = table.get(key);
            GradingThresholds localGT = null;
            if (key.equalsIgnoreCase("PDOP")) {
                localGT = this.getPDOPThresholds();
            } else if (key.equalsIgnoreCase("TDOP")) {
                localGT = this.getPDOPThresholds();
            } else if (key.equalsIgnoreCase("Max S/N Ratio")) {
                localGT = this.getMaxRatioThresholds();
            } else if (key.equalsIgnoreCase("Time Err (ns)")) {
                localGT = this.getTimeErrorThresholds();
            } else if (key.equalsIgnoreCase("# Satellites")) {
                localGT = this.getNumSatThresholds();
            }
            if (localGT == null) continue;
            localGT.setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
    }

    private void setMaxRatioThresholds(GradingThresholds gt) {
        this.maxRatioGT = gt;
        this.getMaxRatioNode().setThresholds(gt);
    }

    private GradingThresholds getMaxRatioThresholds() {
        return this.maxRatioGT;
    }

    private void setTDOPThresholds(GradingThresholds gt) {
        this.tdopGT = gt;
        this.getTDOPNode().setThresholds(gt);
    }

    private GradingThresholds getTDOPThresholds() {
        return this.tdopGT;
    }

    private void setPDOPThresholds(GradingThresholds gt) {
        this.pdopGT = gt;
        this.getPDOPNode().setThresholds(gt);
    }

    private GradingThresholds getPDOPThresholds() {
        return this.pdopGT;
    }

    private void setNumSatThresholds(GradingThresholds gt) {
        this.numSatGT = gt;
        this.getNumSatNode().setThresholds(gt);
    }

    private GradingThresholds getNumSatThresholds() {
        return this.numSatGT;
    }

    private void setTimeErrorThresholds(GradingThresholds gt) {
        this.timeErrGT = gt;
        this.getTimeErrNode().setThresholds(gt);
    }

    private GradingThresholds getTimeErrorThresholds() {
        return this.timeErrGT;
    }

    public String getTableName() {
        String str = NmxHelp.getFieldName("igps.title");
        if (str != null || str.trim().length() > 0) {
            return str;
        }
        return tableName;
    }

    public boolean acceptKey(int key) {
        int model = ChannelKey.getModelOf(key);
        return ChannelKey.getTypeOf(key) == 2 && model != 3;
    }

    public int getColumnCount() {
        return 10;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NmxHelp.getFieldName("station");
            }
            case 1: {
                return NmxHelp.getFieldName("instrument");
            }
            case 2: {
                return NmxHelp.getFieldName("lastupdate");
            }
            case 3: {
                return NmxHelp.getFieldName("igps.clockstate");
            }
            case 4: {
                return NmxHelp.getFieldName("igps.gpsstate");
            }
            case 5: {
                return NmxHelp.getFieldName("igps.timeerror");
            }
            case 6: {
                return NmxHelp.getFieldName("igps.numsat");
            }
            case 7: {
                return NmxHelp.getFieldName("igps.pdop");
            }
            case 8: {
                return NmxHelp.getFieldName("igps.tdop");
            }
            case 9: {
                return NmxHelp.getFieldName("igps.maxratio");
            }
        }
        return "Invalid";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz != null) return clazz;
                try {
                    clazz = class$0 = Class.forName("StationNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz != null) return clazz;
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$2;
                if (clazz != null) return clazz;
                try {
                    clazz = class$2 = Class.forName("DateNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$1;
                if (clazz != null) return clazz;
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$1;
                if (clazz != null) return clazz;
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$3;
                if (clazz != null) return clazz;
                try {
                    clazz = class$3 = Class.forName("DoubleColorNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$3;
                if (clazz != null) return clazz;
                try {
                    clazz = class$3 = Class.forName("DoubleColorNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 7: {
                if (this.isRockwell) {
                    Class<?> clazz = class$4;
                    if (clazz != null) return clazz;
                    try {
                        clazz = class$4 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return clazz;
                }
                Class<?> clazz = class$3;
                if (clazz != null) return clazz;
                try {
                    clazz = class$3 = Class.forName("DoubleColorNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 8: {
                if (this.isRockwell) {
                    Class<?> clazz = class$4;
                    if (clazz != null) return clazz;
                    try {
                        clazz = class$4 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return clazz;
                }
                Class<?> clazz = class$3;
                if (clazz != null) return clazz;
                try {
                    clazz = class$3 = Class.forName("DoubleColorNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
            case 9: {
                if (this.isRockwell) {
                    Class<?> clazz = class$3;
                    if (clazz != null) return clazz;
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return clazz;
                }
                Class<?> clazz = class$4;
                if (clazz != null) return clazz;
                try {
                    clazz = class$4 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz;
            }
        }
        return null;
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new SimpleTableCellRenderer();
            }
            case 1: {
                return new SimpleTableCellRenderer();
            }
            case 2: {
                return new GradedDateSecTableCellRenderer(new GradingThresholds(-30.0, -10.0, 120.0, 600.0));
            }
            case 3: {
                return new NaqsViewTableCellRenderer();
            }
            case 4: {
                return new NaqsViewTableCellRenderer();
            }
            case 5: {
                return new GradedFloatTableCellRenderer(0, new GradingThresholds(0.0, 0.0, 300.0, 1000.0));
            }
            case 6: {
                return new GradedFloatTableCellRenderer(0, new GradingThresholds(1.0, 4.0, 80.0, 100.0));
            }
            case 7: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(0.0, 0.0, 5.0, 8.0));
            }
            case 8: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(0.0, 0.0, 5.0, 8.0));
            }
            case 9: {
                return new GradedFloatTableCellRenderer(0, new GradingThresholds(25.0, 35.0, 100.0, 100.0));
            }
        }
        return null;
    }

    private DoubleColorNode getTimeErrNode() {
        if (this.timeErrNode == null) {
            this.timeErrNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Time Err (ns)", this.bundleType, this.timeErrBundleTypes, "%0.0f", this.dataSource, 0);
            this.timeErrNode.setThresholds(this.getTimeErrorThresholds());
        }
        return this.timeErrNode;
    }

    private DoubleColorNode getNumSatNode() {
        if (this.numSatNode == null) {
            this.numSatNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "# Satellites", this.bundleType, this.numSatBundleTypes, "%0.0f", this.dataSource, 0);
            this.numSatNode.setThresholds(this.getNumSatThresholds());
        }
        return this.numSatNode;
    }

    private DoubleColorNode getPDOPNode() {
        if (this.pdopNode == null) {
            this.pdopNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "PDOP", this.bundleType, this.pdopBundleTypes, "%0.2f", this.dataSource, 2);
            this.pdopNode.setThresholds(this.getPDOPThresholds());
        }
        return this.pdopNode;
    }

    private DoubleColorNode getTDOPNode() {
        if (this.tdopNode == null) {
            this.tdopNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "TDOP", this.bundleType, this.tdopBundleTypes, "%0.2f", this.dataSource, 2);
            this.tdopNode.setThresholds(this.getTDOPThresholds());
        }
        return this.tdopNode;
    }

    private DoubleColorNode getMaxRatioNode() {
        if (this.maxRatioNode == null) {
            this.maxRatioNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Max S/N Ratio", this.bundleType, this.maxRatioBundleTypes, "%0.0f", this.dataSource, 0);
            this.maxRatioNode.setThresholds(this.getMaxRatioThresholds());
        }
        return this.maxRatioNode;
    }

    private StationNode getStationNode() {
        if (this.stationNode == null) {
            this.stationNode = new StationNode(this.getStationName(), this.getChannelName(), this.getInstrument());
            this.stationNode.addNode(this.getTimeErrNode());
            this.stationNode.addNode(this.getNumSatNode());
            this.stationNode.addNode(this.getPDOPNode());
            this.stationNode.addNode(this.getTDOPNode());
            this.stationNode.addNode(this.getMaxRatioNode());
        }
        return this.stationNode;
    }

    private StringNode getGpsStatusNode() {
        if (this.gpsStatusNode == null) {
            this.gpsStatusNode = new StringNode(this.getStationName(), this.getChannelName(), this.getInstrument(), this.bundleType);
        }
        return this.gpsStatusNode;
    }

    private StringNode getPllStatusNode() {
        if (this.pllStatusNode == null) {
            this.pllStatusNode = new StringNode(this.getStationName(), this.getChannelName(), this.getInstrument(), this.bundleType);
        }
        return this.pllStatusNode;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getStationNode();
            }
            case 1: {
                return this.getInstrument();
            }
            case 2: {
                DateNode dNode = this.getDateNode();
                return dNode;
            }
            case 4: {
                StringNode sNode = this.getGpsStatusNode();
                return sNode;
            }
            case 3: {
                StringNode sNode = this.getPllStatusNode();
                return sNode;
            }
            case 5: {
                DoubleColorNode node = this.getTimeErrNode();
                return node;
            }
            case 6: {
                DoubleColorNode node = this.getNumSatNode();
                return node;
            }
            case 7: {
                if (this.isRockwell) {
                    return "";
                }
                DoubleColorNode node = this.getPDOPNode();
                return node;
            }
            case 8: {
                if (this.isRockwell) {
                    return "";
                }
                DoubleColorNode node = this.getTDOPNode();
                return node;
            }
            case 9: {
                if (!this.isRockwell) {
                    return "";
                }
                DoubleColorNode node = this.getMaxRatioNode();
                return node;
            }
        }
        return null;
    }

    public int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 80;
            }
            case 1: {
                return 60;
            }
            case 2: {
                return 120;
            }
            case 4: {
                return 60;
            }
            case 3: {
                return 60;
            }
            case 5: {
                return 60;
            }
            case 6: {
                return 60;
            }
            case 7: {
                return 60;
            }
            case 8: {
                return 60;
            }
            case 9: {
                return 60;
            }
        }
        return 80;
    }

    public void setValueAt(Object aValue, int columnIndex) {
    }

    public boolean isCellEditable(int columnIndex) {
        return false;
    }

    public void processRockwellGps(SohBundle bundle) throws InvalidInputException {
        int type = bundle.getType();
        if (type == 15) {
            RockwellGpsSatelliteBundle rgsb = new RockwellGpsSatelliteBundle(bundle);
            this.lastUpdate = rgsb.getLongSeconds();
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.numSat = rgsb.getNumberOfSatellitesBeingTracked();
            this.getNumSatNode().setCurrentValues(this.numSat, this.lastUpdate);
            this.getNumSatNode().setNew();
            this.maxSNRatio = rgsb.getMaxSNRatio();
            this.getMaxRatioNode().setCurrentValues(this.maxSNRatio, this.lastUpdate);
            this.getMaxRatioNode().setNew();
            this.setNodeNamesAndIndexes(rgsb);
            this.bundleType = 15;
            this.getNumSatNode().setBundleType(this.bundleType);
            this.getMaxRatioNode().setBundleType(this.bundleType);
            this.getTimeErrNode().setOld();
            this.getPDOPNode().setOld();
            this.getTDOPNode().setOld();
            this.getPllStatusNode().setOld();
            this.getGpsStatusNode().setOld();
            this.setChanged();
            this.notifyObservers();
        } else if (type == 7) {
            VcxoCalibrationBundle vcb = new VcxoCalibrationBundle(bundle);
            this.lastUpdate = vcb.getLongSeconds();
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.pllState = vcb.getPllStatusString();
            this.getPllStatusNode().setCurrentValues(this.pllState, this.lastUpdate);
            this.getPllStatusNode().setNew();
            this.gpsState = vcb.getGpsStatusString();
            this.getGpsStatusNode().setCurrentValues(this.gpsState, this.lastUpdate);
            this.getGpsStatusNode().setNew();
            this.systemTQ = Math.abs((int)(1.0E9 * vcb.getTimeErrorSeconds()));
            this.getTimeErrNode().setCurrentValues(this.systemTQ, this.lastUpdate);
            this.getTimeErrNode().setNew();
            this.setNodeNamesAndIndexes(vcb);
            this.bundleType = 7;
            this.getTimeErrNode().setBundleType(this.bundleType);
            this.getNumSatNode().setOld();
            this.getPDOPNode().setOld();
            this.getTDOPNode().setOld();
            this.getMaxRatioNode().setOld();
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void setNodeNamesAndIndexes(SohBundle bundle) {
        int i = 1;
        while (i <= bundle.getColumnCount()) {
            String newStr = bundle.getReadingHeaderByIndex(i);
            if (newStr.indexOf("SystemTimeQuality") >= 0) {
                this.getTimeErrNode().setReadingName(newStr);
                this.getTimeErrNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("UsableSatellites") >= 0) {
                this.getNumSatNode().setReadingName(newStr);
                this.getNumSatNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("PDOP") >= 0) {
                this.getPDOPNode().setReadingName(newStr);
                this.getPDOPNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("TDOP") >= 0) {
                this.getTDOPNode().setReadingName(newStr);
                this.getTDOPNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("NSatTracked") >= 0) {
                this.getNumSatNode().setReadingName(newStr);
                this.getNumSatNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("TimeError") >= 0) {
                this.getTimeErrNode().setReadingName(newStr);
                this.getTimeErrNode().setReadingDataIndex(i);
            }
            ++i;
        }
    }

    public void process(SohBundle bundle) throws InvalidInputException {
        if (bundle.getType() == 55) {
            LibraSystemTimeQualityBundle stqb = new LibraSystemTimeQualityBundle(bundle);
            this.lastUpdate = stqb.getLongSeconds();
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.pllState = stqb.getPllMode();
            this.getPllStatusNode().setCurrentValues(this.pllState, this.lastUpdate);
            this.getPllStatusNode().setNew();
            this.systemTQ = stqb.getTimeQualityVal();
            this.getTimeErrNode().setCurrentValues(this.systemTQ, this.lastUpdate);
            this.getTimeErrNode().setNew();
            this.setNodeNamesAndIndexes(stqb);
            this.bundleType = 55;
            this.getTimeErrNode().setBundleType(this.bundleType);
            this.getNumSatNode().setOld();
            this.getPDOPNode().setOld();
            this.getTDOPNode().setOld();
            this.getMaxRatioNode().setOld();
            this.getGpsStatusNode().setOld();
            this.isRockwell = false;
            this.setChanged();
            this.notifyObservers();
        } else if (bundle.getType() == 54) {
            LibraGpsTimeQualityBundle gtqb = new LibraGpsTimeQualityBundle(bundle);
            this.lastUpdate = gtqb.getLongSeconds();
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.gpsState = gtqb.getGpsStatus();
            this.getGpsStatusNode().setCurrentValues(this.gpsState, this.lastUpdate);
            this.getGpsStatusNode().setNew();
            this.numSat = gtqb.getNumSats();
            this.getNumSatNode().setNew();
            this.getNumSatNode().setCurrentValues(this.numSat, this.lastUpdate);
            this.pdop = gtqb.getPDop();
            this.getPDOPNode().setNew();
            this.getPDOPNode().setCurrentValues(this.pdop, this.lastUpdate);
            this.tdop = gtqb.getTDop();
            this.getTDOPNode().setNew();
            this.getTDOPNode().setCurrentValues(this.tdop, this.lastUpdate);
            this.setNodeNamesAndIndexes(gtqb);
            this.bundleType = 54;
            this.getNumSatNode().setBundleType(this.bundleType);
            this.getPDOPNode().setBundleType(this.bundleType);
            this.getTDOPNode().setBundleType(this.bundleType);
            this.getTimeErrNode().setOld();
            this.getMaxRatioNode().setOld();
            this.getPllStatusNode().setOld();
            this.isRockwell = false;
            this.setChanged();
            this.notifyObservers();
        } else if (this.isRockwell) {
            this.processRockwellGps(bundle);
        }
    }

    public void setDataSource(SohDataSource source) {
        this.dataSource = source;
        this.getTimeErrNode().setDataSource(source);
        this.getNumSatNode().setDataSource(source);
        this.getPDOPNode().setDataSource(source);
        this.getTDOPNode().setDataSource(source);
        this.getMaxRatioNode().setDataSource(source);
    }

    public SohDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean hasPopup(int col) {
        return col == 5 || col == 6 || col == 7 || col == 8 || col == 9;
    }

    public void resetNode(int col) {
        switch (col) {
            case 6: {
                this.getNumSatNode().reset();
                break;
            }
            case 7: {
                this.getPDOPNode().reset();
                break;
            }
            case 8: {
                this.getTDOPNode().reset();
                break;
            }
            case 9: {
                this.getMaxRatioNode().reset();
                break;
            }
            case 5: {
                this.getTimeErrNode().reset();
            }
        }
    }

    public void resetAll() {
        this.getTimeErrNode().reset();
        this.getMaxRatioNode().reset();
        this.getPDOPNode().reset();
        this.getTDOPNode().reset();
        this.getNumSatNode().reset();
    }

    public DoubleNode getDoubleNode(int col) {
        switch (col) {
            case 6: {
                return this.getNumSatNode();
            }
            case 7: {
                return this.getPDOPNode();
            }
            case 8: {
                return this.getTDOPNode();
            }
            case 9: {
                return this.getMaxRatioNode();
            }
            case 5: {
                return this.getTimeErrNode();
            }
        }
        return null;
    }
}

