/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.InstrumentSohBundle;
import ca.nanometrics.bundle.LibraInstrSohBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.SimpleTableCellRenderer;
import ca.nanometrics.util.InvalidInputException;
import javax.swing.table.TableCellRenderer;

public class InstrumentSohTableRow
extends AbstractSohTableRow {
    private int[] bundleTypes = new int[]{48, 34};
    public static final int COLUMN_COUNT = 5;
    public static final int STATION_NAME = 0;
    public static final int INSTRUMENT = 1;
    public static final int LAST_UPDATE = 2;
    public static final int VOLTAGE = 3;
    public static final int TEMPERATURE = 4;
    private long lastUpdate = 0L;
    private float voltage = 0.0f;
    private float temperature = 0.0f;
    private GradingThresholds voltageGT = null;
    private GradingThresholds tempGT = null;
    private boolean hasCC = false;
    private DoubleColorNode voltageNode = null;
    private DoubleColorNode tempNode = null;
    private StationNode stationNode = null;
    private SohDataSource dataSource;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public InstrumentSohTableRow(int theKey, String theStation) {
        super(theKey, theStation);
        this.createThresholds();
    }

    public SohTableRow createTableRow(int key, String name) {
        InstrumentSohTableRow row = new InstrumentSohTableRow(key, name);
        row.setDataSource(this.getDataSource());
        row.setVoltageThresholds(this.getVoltageThresholds());
        row.setTemperatureThresholds(this.getTemperatureThresholds());
        int id = ChannelKey.getIDOf(key);
        row.hasCC = Instrument.isController(id);
        return row;
    }

    private void createThresholds() {
        this.voltageGT = new GradingThresholds(11.0, 12.0, 13.0, 14.0);
        this.tempGT = new GradingThresholds();
    }

    protected void setVoltageThresholds(GradingThresholds gt) {
        this.voltageGT = gt;
        this.getVoltageNode().setThresholds(gt);
    }

    protected GradingThresholds getVoltageThresholds() {
        return this.voltageGT;
    }

    protected void setTemperatureThresholds(GradingThresholds gt) {
        this.tempGT = gt;
        this.getTemperatureNode().setThresholds(gt);
    }

    protected GradingThresholds getTemperatureThresholds() {
        return this.tempGT;
    }

    public String getTableName() {
        String str = NmxHelp.getFieldName("ivat.title");
        if (str != null || str.trim().length() > 0) {
            return str;
        }
        return "Instrument Voltage and Temperature";
    }

    public boolean acceptKey(int key) {
        int model = ChannelKey.getModelOf(key);
        return ChannelKey.getTypeOf(key) == 2 && model != 3;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NmxHelp.getFieldName("station");
            }
            case 1: {
                return NmxHelp.getFieldName("instrument");
            }
            case 2: {
                return NmxHelp.getFieldName("lastupdate");
            }
            case 3: {
                return NmxHelp.getFieldName("ivat.voltage");
            }
            case 4: {
                return NmxHelp.getFieldName("ivat.temperature");
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("StationNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("DateNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        return null;
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new SimpleTableCellRenderer();
            }
            case 1: {
                return new SimpleTableCellRenderer();
            }
            case 2: {
                return new GradedDateSecTableCellRenderer(new GradingThresholds(-30.0, -10.0, 120.0, 600.0));
            }
            case 3: {
                return new GradedFloatTableCellRenderer(2, this.getVoltageThresholds());
            }
            case 4: {
                return new GradedFloatTableCellRenderer(1, this.getTemperatureThresholds());
            }
        }
        return null;
    }

    private StationNode getStationNode() {
        if (this.stationNode == null) {
            this.stationNode = new StationNode(this.getStationName(), this.getChannelName(), this.getInstrument());
            this.stationNode.addNode(this.getVoltageNode());
            this.stationNode.addNode(this.getTemperatureNode());
        }
        return this.stationNode;
    }

    private DoubleColorNode getTemperatureNode() {
        if (this.tempNode == null) {
            this.tempNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Temperature", this.bundleType, this.bundleTypes, "%0.2f", this.dataSource, 1);
            this.tempNode.setThresholds(this.getTemperatureThresholds());
        }
        return this.tempNode;
    }

    private DoubleColorNode getVoltageNode() {
        if (this.voltageNode == null) {
            this.voltageNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Voltage", this.bundleType, this.bundleTypes, "%0.2f", this.dataSource, 2);
            this.voltageNode.setThresholds(this.getVoltageThresholds());
        }
        return this.voltageNode;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getStationNode();
            }
            case 1: {
                return this.getInstrument();
            }
            case 2: {
                return this.getDateNode();
            }
            case 3: {
                return this.getVoltageNode();
            }
            case 4: {
                return this.getTemperatureNode();
            }
        }
        return null;
    }

    public int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 80;
            }
            case 1: {
                return 60;
            }
            case 2: {
                return 120;
            }
            case 3: {
                return 60;
            }
            case 4: {
                return 60;
            }
        }
        return 80;
    }

    public void setValueAt(Object aValue, int columnIndex) {
    }

    public boolean isCellEditable(int columnIndex) {
        return false;
    }

    private void setNodeNamesAndIndexes(SohBundle bundle) {
        String tempStr = bundle instanceof LibraInstrSohBundle ? "ControllerTemp" : "VCXOTemp";
        int i = 0;
        while (i < bundle.getColumnCount()) {
            String newStr = bundle.getReadingHeaderByIndex(i);
            if (newStr.indexOf("Voltage") >= 0) {
                this.getVoltageNode().setReadingName(newStr);
                this.getVoltageNode().setReadingDataIndex(i);
            } else if (newStr.indexOf(tempStr) >= 0) {
                this.getTemperatureNode().setReadingName(newStr);
                this.getTemperatureNode().setReadingDataIndex(i);
            }
            ++i;
        }
    }

    public void setDataSource(SohDataSource source) {
        this.dataSource = source;
        this.getVoltageNode().setDataSource(source);
        this.getTemperatureNode().setDataSource(source);
    }

    public SohDataSource getDataSource() {
        return this.dataSource;
    }

    public void process(SohBundle bundle) throws InvalidInputException {
        if (bundle.getType() == 48) {
            if (!this.hasCC) {
                return;
            }
            LibraInstrSohBundle lisb = new LibraInstrSohBundle(bundle);
            this.lastUpdate = lisb.getLongSeconds();
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.voltage = lisb.getBatVolt();
            this.getVoltageNode().setCurrentValues(this.voltage, this.lastUpdate);
            this.temperature = lisb.getControllerTemp();
            this.getTemperatureNode().setCurrentValues(this.temperature, this.lastUpdate);
            this.setNodeNamesAndIndexes(lisb);
            this.bundleType = 48;
            this.getVoltageNode().setBundleType(this.bundleType);
            this.getTemperatureNode().setBundleType(this.bundleType);
            this.setChanged();
            this.notifyObservers();
        } else if (!this.hasCC && bundle.getType() == 34) {
            InstrumentSohBundle isb = new InstrumentSohBundle(bundle);
            this.lastUpdate = isb.getLongSeconds();
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.voltage = isb.getBatVolts();
            this.getVoltageNode().setCurrentValues(this.voltage, this.lastUpdate);
            this.temperature = isb.getTemperature();
            this.getTemperatureNode().setCurrentValues(this.temperature, this.lastUpdate);
            this.setNodeNamesAndIndexes(isb);
            this.bundleType = 34;
            this.getVoltageNode().setBundleType(this.bundleType);
            this.getTemperatureNode().setBundleType(this.bundleType);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean hasPopup(int col) {
        return col == 3 || col == 4;
    }

    public void resetNode(int col) {
        switch (col) {
            case 3: {
                this.getVoltageNode().reset();
                break;
            }
            case 4: {
                this.getTemperatureNode().reset();
            }
        }
    }

    public void resetAll() {
        this.getVoltageNode().reset();
        this.getTemperatureNode().reset();
    }

    public DoubleNode getDoubleNode(int col) {
        switch (col) {
            case 3: {
                return this.getVoltageNode();
            }
            case 4: {
                return this.getTemperatureNode();
            }
        }
        return null;
    }

    public void applyThresholds(GradingThresholdTable table) {
        GradingThresholds gt = table.get("Voltage");
        if (gt != null) {
            this.getVoltageThresholds().setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
        if ((gt = table.get("Temperature")) != null) {
            this.getTemperatureThresholds().setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
    }
}

