/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.PrintLog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListModel;

public class ListLog
extends PrintLog {
    static final int DEFAULT_LENGTH = 100;
    private VectorListModel logList = new VectorListModel();
    private int maxlen = 100;
    private JMenu logMenu;
    private JRadioButtonMenuItem debugItem;
    private JRadioButtonMenuItem verboseItem;
    private JRadioButtonMenuItem normalItem;

    public ListLog(int maxLogLength) {
        if (maxLogLength > 0) {
            this.maxlen = maxLogLength;
        }
        this.logMenu = this.createMenu();
    }

    public ListLog() {
        this(0);
    }

    public void updateSettings(NaqsViewSettings naqsSettings) {
        LogSettings settings = naqsSettings.getLogSettings();
        settings.setVerbosity(this.getVerbosity());
    }

    public void applySettings(NaqsViewSettings newSettings) {
        LogSettings settings = newSettings.getLogSettings();
        this.setVerbosity(settings.getVerbosity());
        this.updateVerbosityMenu();
    }

    protected JMenu createMenu() {
        JMenu menu = new JMenu("Log");
        menu.setMnemonic('L');
        this.debugItem = new JRadioButtonMenuItem("Debug");
        this.verboseItem = new JRadioButtonMenuItem("Verbose");
        this.normalItem = new JRadioButtonMenuItem("Info");
        VerbosityAction verbosityChanger = new VerbosityAction();
        this.debugItem.addItemListener(verbosityChanger);
        this.verboseItem.addItemListener(verbosityChanger);
        this.normalItem.addItemListener(verbosityChanger);
        JMenuItem mi = menu.add(this.debugItem);
        mi.setMnemonic('D');
        mi = menu.add(this.verboseItem);
        mi.setMnemonic('V');
        mi = menu.add(this.normalItem);
        mi.setMnemonic('N');
        ButtonGroup verbosityGroup = new ButtonGroup();
        verbosityGroup.add(this.debugItem);
        verbosityGroup.add(this.verboseItem);
        verbosityGroup.add(this.normalItem);
        menu.addSeparator();
        mi = menu.add("Clear Log");
        mi.setMnemonic('C');
        mi.addActionListener(new ClearAction());
        return menu;
    }

    public ListModel getLogList() {
        return this.logList;
    }

    public JMenu getMenu() {
        return this.logMenu;
    }

    protected void report(String formattedMessage) {
        this.logList.append(formattedMessage);
        if (this.logList.getSize() >= this.maxlen) {
            this.logList.remove(0);
        }
    }

    public void removeAll() {
        this.logList.clear();
    }

    protected void changeVerbosity() {
        if (this.debugItem.isSelected()) {
            this.setVerbosity(0);
        } else if (this.verboseItem.isSelected()) {
            this.setVerbosity(1);
        } else {
            this.setVerbosity(2);
        }
    }

    protected void updateVerbosityMenu() {
        int verbosity = this.getVerbosity();
        if (verbosity == 0) {
            this.debugItem.setSelected(true);
        } else if (verbosity == 1) {
            this.verboseItem.setSelected(true);
        } else {
            this.normalItem.setSelected(true);
        }
    }

    public void setVerbosity(int val) {
        super.setVerbosity(val);
    }

    public int getVerbosity() {
        return super.getVerbosity();
    }

    class ClearAction
    implements ActionListener {
        ClearAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ListLog.this.removeAll();
        }
    }

    class VerbosityAction
    implements ItemListener {
        VerbosityAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ListLog.this.changeVerbosity();
            }
        }
    }
}

