/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NaqsViewSettings
implements Serializable {
    private LogSettings logSettings = new LogSettings();
    private ConnectionSettings connectionSettings = new ConnectionSettings();
    private CalibrationViewSettings calibrationSettings = new CalibrationViewSettings();
    private ViewSettingsTable viewSettings = new ViewSettingsTable();
    private PlotSettings plotSettings = new PlotSettings();
    private String pdfReader = "";

    public NaqsViewSettings copy() {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ObjectOutputStream obs = new ObjectOutputStream(bas);
            obs.writeObject(this);
            obs.flush();
            ByteArrayInputStream bis = new ByteArrayInputStream(bas.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            NaqsViewSettings newSettings = (NaqsViewSettings)ois.readObject();
            return newSettings;
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof NaqsViewSettings) {
            NaqsViewSettings nvs = (NaqsViewSettings)obj;
            return this.logSettings.equals(nvs.getLogSettings()) && this.connectionSettings.equals(nvs.getConnectionSettings()) && this.calibrationSettings.equals(nvs.getCalibrationSettings()) && this.viewSettings.equals(nvs.viewSettings) && this.plotSettings.equals(nvs.plotSettings) && this.getPdfReader().equals(nvs.getPdfReader());
        }
        return false;
    }

    public LogSettings getLogSettings() {
        return this.logSettings;
    }

    public PlotSettings getPlotSettings() {
        return this.plotSettings;
    }

    public String getPdfReader() {
        if (this.pdfReader == null) {
            return "";
        }
        return this.pdfReader;
    }

    public void setPdfReader(String reader) {
        this.pdfReader = reader;
    }

    public void updatePlotSettings(PlotSettings newSettings) {
        if (newSettings == null) {
            return;
        }
        PlotSettings oldSettings = this.getPlotSettings();
        oldSettings.setDuration(newSettings.getDuration());
        oldSettings.setMostRecent(newSettings.getMostRecent());
        oldSettings.setScroll(newSettings.scroll());
        oldSettings.setShowThreshold(newSettings.getShowThreshold());
        oldSettings.setSingleHistory(newSettings.getSingleHistory());
        oldSettings.setStartTime(newSettings.getStartTime());
        oldSettings.setUnitsString(newSettings.getUnitString());
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public CalibrationViewSettings getCalibrationSettings() {
        return this.calibrationSettings;
    }

    public SohViewSettings getViewSettings(String name) {
        return this.viewSettings.get(name);
    }

    public void addViewSettings(String name, SohViewSettings settings) {
        this.viewSettings.add(name, settings);
    }

    public int getViewNumber() {
        return this.viewSettings.size();
    }

    public ViewSettingsTable getViewSettingsTable() {
        return this.viewSettings;
    }
}

