/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class PlotData
implements Comparable {
    private double[] x = null;
    private double[] y = null;
    private DoubleNode node;
    private double startTime;
    private double endTime;
    private int precision;
    private Color color;

    public PlotData(DoubleNode node, double startTime, double endTime) {
        this.node = node;
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setPrecision();
    }

    public Color getColor() {
        return this.color;
    }

    public double[] getTimeSeries() {
        if (this.x == null) {
            this.x = this.node.getTimeSeries(this.startTime, this.endTime);
        }
        return this.x;
    }

    public double[] getDataSeries() {
        if (this.y == null) {
            this.y = this.node.getDataSeries(this.startTime, this.endTime);
        }
        if (this.y == null) {
            return null;
        }
        return this.y;
    }

    public String getVariableName() {
        return this.node.getReadingName();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setColor(Color color_) {
        this.color = color_;
    }

    public void setPrecision() {
        this.precision = this.node.getPrecision();
    }

    private void setStartTime(double time) {
        this.startTime = time;
    }

    private void setEndTime(double time) {
        this.endTime = time;
    }

    public void updateData(double startTime, double endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.updateData();
    }

    public void updateData() {
        this.x = this.node.getTimeSeries(this.startTime, this.endTime);
        this.y = this.node.getDataSeries(this.startTime, this.endTime);
    }

    public DoubleNode getNode() {
        return this.node;
    }

    public String toString() {
        return String.valueOf(this.node.getName()) + "." + this.getVariableName();
    }

    public int compareTo(Object o) {
        if (o instanceof PlotData) {
            PlotData data = (PlotData)o;
            return -data.toString().compareTo(this.toString());
        }
        return -2;
    }
}

