/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.table.IndexedTableMap;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.TableModel;

public class RowSelector
extends IndexedTableMap {
    private Hashtable selectedRows = new Hashtable();

    public RowSelector() {
    }

    public RowSelector(TableModel model) {
        this.setModel(model);
    }

    public synchronized Vector getAvailableRows() {
        Vector<String> rows = new Vector<String>();
        int numRows = this.model.getRowCount();
        int irow = 0;
        while (irow < numRows) {
            rows.addElement(this.model.getValueAt(irow, 0).toString());
            ++irow;
        }
        return rows;
    }

    public synchronized Vector getSelectedRows() {
        Vector rows = new Vector();
        Enumeration e = this.selectedRows.elements();
        while (e.hasMoreElements()) {
            rows.addElement(e.nextElement());
        }
        return rows;
    }

    public synchronized void setSelectedRows(Vector rows) {
        this.selectedRows.clear();
        Enumeration e = rows.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            this.selectedRows.put(obj.toString(), obj.toString());
        }
        this.remap();
    }

    public void selectAllRows() {
        this.setSelectedRows(this.getAvailableRows());
    }

    public boolean isSelected(Object obj) {
        if (obj != null) {
            return this.selectedRows.contains(obj);
        }
        return false;
    }

    protected void updateForwardMap() {
        Vector available = this.getAvailableRows();
        int modelRows = available.size();
        int visibleCount = 0;
        int irow = 0;
        while (irow < modelRows) {
            Object obj = available.elementAt(irow);
            if (this.selectedRows.containsKey(obj.toString())) {
                ++visibleCount;
            }
            ++irow;
        }
        this.indexes = new int[visibleCount];
        int vrow = 0;
        int irow2 = 0;
        while (irow2 < modelRows) {
            Object obj = available.elementAt(irow2);
            if (this.selectedRows.containsKey(obj)) {
                this.indexes[vrow++] = irow2;
            }
            ++irow2;
        }
    }
}

