/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.LibraInstrSohBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.SimpleTableCellRenderer;
import ca.nanometrics.util.InvalidInputException;
import javax.swing.table.TableCellRenderer;

public class SatModemTableRow
extends AbstractSohTableRow {
    private int[] bundleTypes = new int[]{48};
    public static final int COLUMN_COUNT = 8;
    public static final int STATION_NAME = 0;
    public static final int INSTRUMENT = 1;
    public static final int LAST_UPDATE = 2;
    public static final int VOLTAGE = 3;
    public static final int CONTTEMP = 4;
    public static final int SSPBTEMP = 5;
    public static final int MODMTEMP = 6;
    public static final int FREQERR = 7;
    private StationNode stationNode;
    private long lastUpdate = 0L;
    private float voltage = 0.0f;
    private float contTemp = 0.0f;
    private float sspbTemp = 0.0f;
    private float modemTemp = 0.0f;
    private float freqError = 0.0f;
    private DoubleColorNode voltageNode;
    private DoubleColorNode contTempNode;
    private DoubleColorNode sspbTempNode;
    private DoubleColorNode modemTempNode;
    private DoubleColorNode freqErrorNode;
    private GradingThresholds voltageGT;
    private GradingThresholds contTempGT;
    private GradingThresholds sspbTempGT;
    private GradingThresholds modemTempGT;
    private GradingThresholds freqErrorGT;
    SohDataSource dataSource;
    PlotSettings plotSettings;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SatModemTableRow(int theKey, String theStation) {
        super(theKey, theStation);
        this.createThresholds();
    }

    public SohTableRow createTableRow(int key, String name) {
        SatModemTableRow row = new SatModemTableRow(key, name);
        row.setDataSource(this.getDataSource());
        row.setVoltageThresholds(this.getVoltageThresholds());
        row.setContTempThresholds(this.getContTempThresholds());
        row.setSSPBTempThresholds(this.getSSPBTempThresholds());
        row.setModemTempThresholds(this.getModemTempThresholds());
        row.setFreqErrorThresholds(this.getFreqErrorThresholds());
        return row;
    }

    private void createThresholds() {
        this.voltageGT = new GradingThresholds(11.0, 12.0, 15.0, 16.0);
        this.contTempGT = new GradingThresholds(5.0, 10.0, 40.0, 45.0);
        this.sspbTempGT = new GradingThresholds(5.0, 10.0, 40.0, 45.0);
        this.modemTempGT = new GradingThresholds(5.0, 10.0, 40.0, 45.0);
        this.freqErrorGT = new GradingThresholds(-5000.0, -3000.0, 3000.0, 5000.0);
    }

    public void applyThresholds(GradingThresholdTable table) {
        GradingThresholds gt = table.get("Voltage");
        if (gt != null) {
            this.getVoltageThresholds().setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
        if ((gt = table.get("Modem Temp")) != null) {
            this.getModemTempThresholds().setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
    }

    private void setFreqErrorThresholds(GradingThresholds gt) {
        this.freqErrorGT = gt;
        this.getFreqErrorNode().setThresholds(gt);
    }

    private GradingThresholds getFreqErrorThresholds() {
        return this.freqErrorGT;
    }

    private void setVoltageThresholds(GradingThresholds gThresholds) {
        this.voltageGT = gThresholds;
        this.getVoltageNode().setThresholds(this.voltageGT);
    }

    private GradingThresholds getVoltageThresholds() {
        return this.voltageGT;
    }

    private void setContTempThresholds(GradingThresholds gThresholds) {
        this.contTempGT = gThresholds;
        this.getContTempNode().setThresholds(this.contTempGT);
    }

    private GradingThresholds getContTempThresholds() {
        return this.contTempGT;
    }

    private void setSSPBTempThresholds(GradingThresholds gThresholds) {
        this.sspbTempGT = gThresholds;
        this.getSSPBTempNode().setThresholds(this.sspbTempGT);
    }

    private GradingThresholds getSSPBTempThresholds() {
        return this.sspbTempGT;
    }

    private void setModemTempThresholds(GradingThresholds gThresholds) {
        this.modemTempGT = gThresholds;
        this.getModemTempNode().setThresholds(this.modemTempGT);
    }

    private GradingThresholds getModemTempThresholds() {
        return this.modemTempGT;
    }

    public String getTableName() {
        return NmxHelp.getFieldName("smsoh.title");
    }

    public boolean acceptKey(int key) {
        int model = ChannelKey.getModelOf(key);
        return ChannelKey.getTypeOf(key) == 2 && (model == 4 || model == 5 || model == 7);
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NmxHelp.getFieldName("station");
            }
            case 1: {
                return NmxHelp.getFieldName("instrument");
            }
            case 2: {
                return NmxHelp.getFieldName("lastupdate");
            }
            case 3: {
                return NmxHelp.getFieldName("smsoh.voltage");
            }
            case 4: {
                return NmxHelp.getFieldName("smsoh.controllertemp");
            }
            case 5: {
                return NmxHelp.getFieldName("smsoh.sspbtemp");
            }
            case 6: {
                return NmxHelp.getFieldName("smsoh.modemtemp");
            }
            case 7: {
                return NmxHelp.getFieldName("smsoh.freqerr");
            }
        }
        return "No Name";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("StationNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("DateNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        return null;
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new SimpleTableCellRenderer();
            }
            case 1: {
                return new SimpleTableCellRenderer();
            }
            case 2: {
                return new GradedDateSecTableCellRenderer(new GradingThresholds(-30.0, -10.0, 120.0, 600.0));
            }
            case 3: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(11.0, 12.0, 15.0, 16.0));
            }
            case 4: {
                return new GradedFloatTableCellRenderer(1, new GradingThresholds(5.0, 10.0, 40.0, 45.0));
            }
            case 5: {
                return new GradedFloatTableCellRenderer(1, new GradingThresholds(5.0, 10.0, 40.0, 45.0));
            }
            case 6: {
                return new GradedFloatTableCellRenderer(1, new GradingThresholds(5.0, 10.0, 40.0, 45.0));
            }
            case 7: {
                return new GradedFloatTableCellRenderer(1, new GradingThresholds(-5000.0, -3000.0, 3000.0, 5000.0));
            }
        }
        return null;
    }

    private DoubleColorNode getVoltageNode() {
        if (this.voltageNode == null) {
            this.voltageNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Voltage", this.bundleType, this.bundleTypes, "%0.2f", this.dataSource, 2);
            this.voltageNode.setThresholds(this.getVoltageThresholds());
        }
        return this.voltageNode;
    }

    private DoubleColorNode getContTempNode() {
        if (this.contTempNode == null) {
            this.contTempNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Controller Temp", this.bundleType, this.bundleTypes, "%0.1f", this.dataSource, 1);
            this.contTempNode.setThresholds(this.getContTempThresholds());
        }
        return this.contTempNode;
    }

    private DoubleColorNode getSSPBTempNode() {
        if (this.sspbTempNode == null) {
            this.sspbTempNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "SSPB Temp", this.bundleType, this.bundleTypes, "%0.1f", this.dataSource, 1);
            this.sspbTempNode.setThresholds(this.getSSPBTempThresholds());
        }
        return this.sspbTempNode;
    }

    private DoubleColorNode getModemTempNode() {
        if (this.modemTempNode == null) {
            this.modemTempNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Modem Temp", this.bundleType, this.bundleTypes, "%0.1f", this.dataSource, 1);
            this.modemTempNode.setThresholds(this.getModemTempThresholds());
        }
        return this.modemTempNode;
    }

    private DoubleColorNode getFreqErrorNode() {
        if (this.freqErrorNode == null) {
            this.freqErrorNode = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Freq Err", this.bundleType, this.bundleTypes, "%0.1f", this.dataSource, 1);
            this.freqErrorNode.setThresholds(this.getFreqErrorThresholds());
        }
        return this.freqErrorNode;
    }

    private StationNode getStationNode() {
        if (this.stationNode == null) {
            this.stationNode = new StationNode(this.getStationName(), this.getChannelName(), this.getInstrument());
            this.stationNode.addNode(this.getVoltageNode());
            this.stationNode.addNode(this.getContTempNode());
            this.stationNode.addNode(this.getSSPBTempNode());
            this.stationNode.addNode(this.getModemTempNode());
            this.stationNode.addNode(this.getFreqErrorNode());
        }
        return this.stationNode;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getStationNode();
            }
            case 1: {
                return this.getInstrument();
            }
            case 2: {
                DateNode dNode = this.getDateNode();
                dNode.setCurrentTime(this.lastUpdate);
                return dNode;
            }
            case 3: {
                DoubleColorNode node = this.getVoltageNode();
                node.setCurrentValues(this.voltage, this.lastUpdate);
                return node;
            }
            case 4: {
                DoubleColorNode node = this.getContTempNode();
                node.setCurrentValues(this.contTemp, this.lastUpdate);
                return node;
            }
            case 5: {
                DoubleColorNode node = this.getSSPBTempNode();
                node.setCurrentValues(this.sspbTemp, this.lastUpdate);
                return node;
            }
            case 6: {
                DoubleColorNode node = this.getModemTempNode();
                node.setCurrentValues(this.modemTemp, this.lastUpdate);
                return node;
            }
            case 7: {
                DoubleColorNode node = this.getFreqErrorNode();
                node.setCurrentValues(this.freqError, this.lastUpdate);
                return node;
            }
        }
        return null;
    }

    public int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 80;
            }
            case 1: {
                return 60;
            }
            case 2: {
                return 120;
            }
            case 3: {
                return 60;
            }
            case 4: {
                return 60;
            }
            case 5: {
                return 60;
            }
            case 6: {
                return 60;
            }
            case 7: {
                return 60;
            }
        }
        return 80;
    }

    public void setValueAt(Object aValue, int columnIndex) {
    }

    public boolean isCellEditable(int columnIndex) {
        return false;
    }

    private void setNodeNamesAndIndexes(SohBundle bundle) {
        int i = 1;
        while (i <= bundle.getColumnCount()) {
            String newStr = bundle.getReadingHeaderByIndex(i);
            if (newStr.indexOf("BatteryVoltage") >= 0) {
                this.getVoltageNode().setReadingName(newStr);
                this.getVoltageNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("10MHzFreqError") >= 0) {
                this.getFreqErrorNode().setReadingName(newStr);
                this.getFreqErrorNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("SSPBTemp") >= 0) {
                this.getSSPBTempNode().setReadingName(newStr);
                this.getSSPBTempNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("ControllerTemp") >= 0) {
                this.getContTempNode().setReadingName(newStr);
                this.getContTempNode().setReadingDataIndex(i);
            } else if (newStr.indexOf("ModemTemp") >= 0) {
                this.getModemTempNode().setReadingName(newStr);
                this.getModemTempNode().setReadingDataIndex(i);
            }
            ++i;
        }
    }

    public void process(SohBundle bundle) {
        try {
            LibraInstrSohBundle lisb = new LibraInstrSohBundle(bundle);
            this.lastUpdate = lisb.getLongSeconds();
            this.voltage = lisb.getBatVolt();
            this.contTemp = lisb.getControllerTemp();
            this.sspbTemp = lisb.getSspbTemp();
            this.modemTemp = lisb.getModemTemp();
            this.freqError = lisb.getTenMHzFreqError();
            this.setNodeNamesAndIndexes(lisb);
            this.bundleType = 48;
            this.getVoltageNode().setBundleType(this.bundleType);
            this.getContTempNode().setBundleType(this.bundleType);
            this.getSSPBTempNode().setBundleType(this.bundleType);
            this.getModemTempNode().setBundleType(this.bundleType);
            this.getFreqErrorNode().setBundleType(this.bundleType);
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.getVoltageNode().setCurrentValues(this.voltage, this.lastUpdate);
            this.getContTempNode().setCurrentValues(this.contTemp, this.lastUpdate);
            this.getSSPBTempNode().setCurrentValues(this.sspbTemp, this.lastUpdate);
            this.getModemTempNode().setCurrentValues(this.modemTemp, this.lastUpdate);
            this.getFreqErrorNode().setCurrentValues(this.freqError, this.lastUpdate);
            this.setChanged();
            this.notifyObservers();
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    public void setDataSource(SohDataSource source) {
        this.dataSource = source;
        this.getVoltageNode().setDataSource(source);
        this.getContTempNode().setDataSource(source);
        this.getSSPBTempNode().setDataSource(source);
        this.getModemTempNode().setDataSource(source);
        this.getFreqErrorNode().setDataSource(source);
    }

    public SohDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean hasPopup(int col) {
        return col == 3 || col == 4 || col == 5 || col == 6 || col == 7;
    }

    public void resetNode(int col) {
        switch (col) {
            case 3: {
                this.getVoltageNode().reset();
                break;
            }
            case 4: {
                this.getContTempNode().reset();
                break;
            }
            case 5: {
                this.getSSPBTempNode().reset();
                break;
            }
            case 6: {
                this.getModemTempNode().reset();
                break;
            }
            case 7: {
                this.getFreqErrorNode().reset();
            }
        }
    }

    public DoubleNode getDoubleNode(int col) {
        switch (col) {
            case 3: {
                return this.getVoltageNode();
            }
            case 4: {
                return this.getContTempNode();
            }
            case 5: {
                return this.getSSPBTempNode();
            }
            case 6: {
                return this.getModemTempNode();
            }
            case 7: {
                return this.getFreqErrorNode();
            }
        }
        return null;
    }

    public void resetAll() {
        this.getVoltageNode().reset();
        this.getContTempNode().reset();
        this.getSSPBTempNode().reset();
        this.getModemTempNode().reset();
        this.getFreqErrorNode().reset();
    }
}

