/*
 * Decompiled with CFR 0.152.
 */
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SingleHistoryPlot
extends HistoryPanel {
    PlotData data;

    public SingleHistoryPlot(PlotData data_, double startTime_, double endTime_, int thresholdChoice, boolean doFirstDiff) {
        super(startTime_, endTime_, String.valueOf(data_.getNode().getName()) + " " + data_.getVariableName(), thresholdChoice, doFirstDiff);
        this.setLayout(new BorderLayout());
        this.data = data_;
        if (!this.createChart()) {
            this.setIsPlot(false);
            String str = "No Data To Plot for station: " + this.data.getNode().getName();
            str = this.data.getVariableName() == null || this.data.getVariableName().equals("") ? String.valueOf(str) : String.valueOf(str) + "." + this.data.getVariableName();
            JTextField label = new JTextField(str);
            label.setForeground(Color.red);
            label.setBackground(Color.white);
            this.add(label);
            this.setSuccess(false);
            this.setPreferredSize(new Dimension(500, 30));
        } else {
            this.setPreferredSize(new Dimension(500, 200));
        }
    }

    protected boolean createChart() {
        this.chart = new JCChart();
        double[] x = this.getTimeSeries(this.data);
        if (x == null) {
            return false;
        }
        double[] y = this.getDataSeries(this.data);
        if (y == null) {
            return false;
        }
        ChartDataSource source = new ChartDataSource(x, y, this.data.getPrecision());
        if (source != null) {
            this.chart.getDataView(0).setDataSource((ChartDataModel)source);
            this.chart.getDataView(0).setHoleValue(source.getHoleValue());
        } else {
            System.out.println("source is null");
        }
        JCChartArea chartArea = this.chart.getChartArea();
        JCAxis xAxis = chartArea.getXAxis(0);
        xAxis.setMin(Math.floor(source.getMinXValue()));
        xAxis.setMax(Math.ceil(source.getMaxXValue()));
        xAxis.setLabelGenerator((JCLabelGenerator)new ChartTimeLabelGenerator("Md_HH:mm:ss"));
        String titleStr = this.getDate(source.getMinXValue(), source.getMaxXValue());
        if (this.firstDiff) {
            titleStr = "First Differences  " + titleStr;
        }
        JCAxisTitle xAxisTitle = new JCAxisTitle(titleStr);
        xAxisTitle.setPlacement(32);
        xAxis.setTitle(xAxisTitle);
        this.chart.getHeader().setVisible(true);
        ((JLabel)this.chart.getHeader()).setText(this.getPlotName());
        this.chart.setBackground(Color.white);
        JCAxis yAxis = chartArea.getYAxis(0);
        yAxis.setPlacement(1);
        yAxis.setPrecision(this.data.getPrecision());
        JCAxisTitle title = new JCAxisTitle(this.data.getVariableName());
        title.setRotation(3);
        title.setPlacement(2);
        yAxis.setTitle(title);
        HistoryPanel.MinMaxCalculator calc = new HistoryPanel.MinMaxCalculator(source.getMinYValue(), source.getMaxYValue(), source.getPrecision());
        yAxis.setMin(calc.getMinValue());
        yAxis.setMax(calc.getMaxValue());
        yAxis.setNumSpacing(calc.getNumSpacing());
        yAxis.setOriginPlacement(3);
        ChartDataViewSeries series = this.chart.getDataView(0).getSeries(0);
        JCChartStyle oldStyle = series.getStyle();
        JCChartStyle style = new JCChartStyle(oldStyle.getLineStyle(), oldStyle.getFillStyle(), new JCSymbolStyle(0, null, 0));
        series.setStyle(style);
        this.setRangeAppearances();
        this.chart.setAllowUserChanges(true);
        this.chart.setTrigger(0, new EventTrigger(1, 6));
        this.chart.setPreferredSize(new Dimension(500, 200));
        this.chart.addMouseListener((MouseListener)new HistoryPanel.ChartMouseListener());
        this.add((Component)this.chart, "Center");
        return true;
    }

    private void setRangeAppearances() {
        if (this.firstDiff) {
            return;
        }
        if (this.getThresholdChoice() == HistoryViewer.NO_THRESHOLDS) {
            return;
        }
        ChartDataViewSeries series = this.chart.getDataView(0).getSeries(1);
        JCLineStyle line = new JCLineStyle(1, Color.red, 2);
        JCChartStyle style = new JCChartStyle(line, new JCFillStyle(Color.red, 0), new JCSymbolStyle(0, null, 0));
        series.setStyle(style);
        series = this.chart.getDataView(0).getSeries(2);
        line = new JCLineStyle(1, Color.green, 2);
        style = new JCChartStyle(line, new JCFillStyle(Color.green, 0), new JCSymbolStyle(0, null, 0));
        series.setStyle(style);
        series = this.chart.getDataView(0).getSeries(3);
        line = new JCLineStyle(1, Color.green, 2);
        style = new JCChartStyle(line, new JCFillStyle(Color.green, 0), new JCSymbolStyle(0, null, 0));
        series.setStyle(style);
        series = this.chart.getDataView(0).getSeries(4);
        line = new JCLineStyle(1, Color.red, 2);
        style = new JCChartStyle(line, new JCFillStyle(Color.red, 0), new JCSymbolStyle(0, null, 0));
        series.setStyle(style);
    }

    public Vector getData() {
        Vector<PlotData> retV = new Vector<PlotData>();
        retV.add(this.data);
        return retV;
    }

    public void saveData(String dirName) {
        this.saveData(this.data.getNode(), dirName);
    }

    class ChartDataSource
    implements ChartDataModel,
    HoleValueChartDataModel {
        double[] x;
        double[] y;
        double[] tx;
        double[] t1;
        double[] t2;
        double[] t3;
        double[] t4;
        int prec = 0;

        ChartDataSource(double[] x, double[] y, int precision) {
            this.setMainSeries(x, y);
            if (!SingleHistoryPlot.this.firstDiff) {
                this.setThresholdSeries();
            }
            this.prec = precision;
        }

        private void setThresholdSeries() {
            this.t1 = new double[2];
            this.t2 = new double[2];
            this.t3 = new double[2];
            this.t4 = new double[2];
            int i = 0;
            while (i < 2) {
                this.t1[i] = SingleHistoryPlot.this.data.getNode().getThreshold1();
                this.t2[i] = SingleHistoryPlot.this.data.getNode().getThreshold2();
                this.t3[i] = SingleHistoryPlot.this.data.getNode().getThreshold3();
                this.t4[i] = SingleHistoryPlot.this.data.getNode().getThreshold4();
                ++i;
            }
            this.tx = new double[2];
            this.tx[0] = SingleHistoryPlot.this.startTime;
            this.tx[1] = SingleHistoryPlot.this.endTime;
        }

        private void setMainSeries(double[] xSeries, double[] ySeries) {
            this.x = xSeries;
            this.y = ySeries;
            this.insertHoleValues();
        }

        private void insertHoleValues() {
            if (this.x.length < 4) {
                return;
            }
            ArrayList<Double> newX = new ArrayList<Double>();
            ArrayList<Double> newY = new ArrayList<Double>();
            int currInt = (int)Math.abs(this.x[0] - this.x[1]);
            int i = 0;
            while (i < this.x.length - 1) {
                int newInt = (int)Math.abs(this.x[i] - this.x[i + 1]);
                if ((double)newInt > (double)currInt * 1.2 || (double)newInt < (double)currInt * 0.8) {
                    Double lastY = (Double)newY.get(newX.size() - 1);
                    newX.add(new Double(this.x[i]));
                    newY.add(new Double(this.y[i]));
                    if (lastY.doubleValue() != this.getHoleValue()) {
                        newX.add(new Double(this.x[i] + (this.x[i + 1] - this.x[i]) / 2.0));
                        newY.add(new Double(this.getHoleValue()));
                    }
                    currInt = newInt;
                } else {
                    newX.add(new Double(this.x[i]));
                    newY.add(new Double(this.y[i]));
                }
                ++i;
            }
            newX.add(new Double(this.x[this.x.length - 1]));
            newY.add(new Double(this.y[this.y.length - 1]));
            double[] newXArray = new double[newX.size()];
            double[] newYArray = new double[newY.size()];
            int i2 = 0;
            while (i2 < newX.size()) {
                newXArray[i2] = (Double)newX.get(i2);
                newYArray[i2] = (Double)newY.get(i2);
                ++i2;
            }
            this.x = newXArray;
            this.y = newYArray;
        }

        public int getNumSeries() {
            if (SingleHistoryPlot.this.getThresholdChoice() == HistoryViewer.NO_THRESHOLDS || SingleHistoryPlot.this.firstDiff) {
                return 1;
            }
            return 5;
        }

        public double[] getXSeries(int param) {
            if (param == 0) {
                return this.x;
            }
            return this.tx;
        }

        public double[] getYSeries(int param) {
            double[] retVal = null;
            switch (param) {
                case 0: {
                    retVal = this.y;
                    break;
                }
                case 1: {
                    retVal = this.t1;
                    break;
                }
                case 2: {
                    retVal = this.t2;
                    break;
                }
                case 3: {
                    retVal = this.t3;
                    break;
                }
                case 4: {
                    retVal = this.t4;
                }
            }
            return retVal;
        }

        public double getMaxYValue() {
            double maxVal = -1.7976931348623157E308;
            int i = 0;
            while (i < this.y.length) {
                if (this.y[i] > maxVal && this.y[i] != this.getHoleValue()) {
                    maxVal = this.y[i];
                }
                ++i;
            }
            if (SingleHistoryPlot.this.firstDiff) {
                if (maxVal == -1.7976931348623157E308) {
                    maxVal = 100.0;
                }
                return maxVal;
            }
            if (SingleHistoryPlot.this.getThresholdChoice() == HistoryViewer.DEFAULT_THRESHOLDS) {
                if (SingleHistoryPlot.this.data.getNode().getThreshold3() > maxVal) {
                    maxVal = SingleHistoryPlot.this.data.getNode().getThreshold3();
                }
            } else if (SingleHistoryPlot.this.getThresholdChoice() == HistoryViewer.ALL_THRESHOLDS && SingleHistoryPlot.this.data.getNode().getThreshold4() > maxVal) {
                maxVal = SingleHistoryPlot.this.data.getNode().getThreshold4();
            }
            if (maxVal == -1.7976931348623157E308) {
                maxVal = 100.0;
            }
            return maxVal;
        }

        public double getMinXValue() {
            return this.x[0];
        }

        public double getMaxXValue() {
            return this.x[this.x.length - 1];
        }

        public double getMinYValue() {
            double minVal = Double.MAX_VALUE;
            int i = 0;
            while (i < this.y.length) {
                if (this.y[i] < minVal && this.y[i] != this.getHoleValue()) {
                    minVal = this.y[i];
                }
                ++i;
            }
            if (SingleHistoryPlot.this.firstDiff) {
                if (minVal == Double.MAX_VALUE) {
                    minVal = 0.0;
                }
                return minVal;
            }
            if (SingleHistoryPlot.this.getThresholdChoice() == HistoryViewer.DEFAULT_THRESHOLDS) {
                if (SingleHistoryPlot.this.data.getNode().getThreshold2() < minVal) {
                    minVal = SingleHistoryPlot.this.data.getNode().getThreshold2();
                }
                return minVal;
            }
            if (SingleHistoryPlot.this.getThresholdChoice() == HistoryViewer.ALL_THRESHOLDS && SingleHistoryPlot.this.data.getNode().getThreshold1() < minVal) {
                minVal = SingleHistoryPlot.this.data.getNode().getThreshold1();
            }
            if (minVal == Double.MAX_VALUE) {
                minVal = 0.0;
            }
            return minVal;
        }

        public int getPrecision() {
            return this.prec;
        }

        public double getHoleValue() {
            return Double.MAX_VALUE;
        }
    }
}

