/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.table.NmxTable;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.Log;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class StationNode
extends NaqsNode {
    public static final int INST_VOLTAGE_TEMPERATURE = 0;
    public static final int ENVIRONMENTAL_SOH = 1;
    public static final int SAT_MODEM_SOH = 2;
    public static final int RM4_VOLTAGE_TEMP = 3;
    public static final int INST_GPS_STN = 4;
    public static final int MASS_POS_CENTER = 5;
    private double start = 0.0;
    protected ArrayList nodes = new ArrayList();

    public StationNode(String stn, String chan, String instr) {
        super(stn, chan, instr, "Station");
        this.start = Math.floor(System.currentTimeMillis() / 1000L);
    }

    private void joinHistoryViewer(int viewerIndex) {
        if (viewerIndex >= HistoryViewer.viewers.size()) {
            return;
        }
        HistoryViewer viewer = (HistoryViewer)HistoryViewer.viewers.get(viewerIndex);
        viewer.addNodes(this.nodes);
    }

    private boolean checkDataServer() {
        if (this.nodes.size() == 0) {
            return false;
        }
        DoubleNode node = (DoubleNode)this.nodes.get(0);
        SohDataSource source = node.getDataSource();
        try {
            source.pingSource();
        }
        catch (IOException ioe) {
            String message = ioe.getMessage().indexOf("Connection refused") >= 0 ? "DataServer Unavailable; Error: Connection Refused" : "DataServer Unavailable; Error: " + ioe.getMessage();
            Log.report(this, 1, 3, message);
            ErrorDisplay.display(message, "DataServer Connection Failure");
            return false;
        }
        catch (IllegalArgumentException iae) {
            Log.report(this, 1, 3, "Failed to connect to DataServer; Error: Port Number: " + source.getPort() + " out of range");
            ErrorDisplay.display("Failed to connect to DataServer; Error: Port Number: " + source.getPort() + " out of range", "DataServer Connection Problem");
            return false;
        }
        return true;
    }

    protected void createHistoryViewer(int viewerIndex) {
        if (!this.checkDataServer()) {
            return;
        }
        if (viewerIndex > 0) {
            this.joinHistoryViewer(viewerIndex - 1);
            return;
        }
        HistoryDurationDialog dlog = null;
        try {
            dlog = new HistoryDurationDialog(this.start, Math.ceil(System.currentTimeMillis() / 1000L) - this.start);
        }
        catch (IOException e) {
            ErrorDisplay.display("Unable to display Dialog; Error: " + e.getMessage(), "Dialog Failure");
            return;
        }
        if (dlog.getSuccess()) {
            double startTime = dlog.getStartTime();
            double endTime = startTime + dlog.getDuration();
            NaqsView.statusBar.push(0, "Creating History Viewer...");
            HistoryViewer hv = new HistoryViewer(this.nodes, startTime, endTime, HistoryViewer.viewers.size() + 1);
            if (!hv.success()) {
                return;
            }
            hv.setVisible(true);
            hv.toFront();
            NaqsView.statusBar.pop();
        }
    }

    public void addNode(DoubleNode node) {
        if (this.nodes.contains(node)) {
            return;
        }
        this.nodes.add(node);
    }

    public DoubleNode getNode(int i) {
        if (this.nodes.size() < i) {
            return (DoubleNode)this.nodes.get(i);
        }
        return null;
    }

    public ArrayList getNodes() {
        return this.nodes;
    }

    public void resetNodes() {
        int i = 0;
        while (i < this.nodes.size()) {
            DoubleNode node = (DoubleNode)this.nodes.get(i);
            node.reset();
            ++i;
        }
    }

    public void clearNodes() {
        this.nodes = new ArrayList();
    }

    public String toString() {
        return this.getName();
    }

    public void rightClick(JComponent showHere, int x, int y) {
        JPopupMenu popUp = new JPopupMenu();
        popUp.add(new ResetAction(showHere));
        if (showHere instanceof NmxTable) {
            popUp.addSeparator();
            ArrayList viewers = HistoryViewer.viewers;
            if (viewers.size() == 0) {
                popUp.add(new HistoryAction("History", 0));
            } else {
                JMenu historyPopup = new JMenu("History");
                historyPopup.add(new HistoryAction("New History", 0));
                int i = 0;
                while (i < viewers.size()) {
                    HistoryViewer viewer = (HistoryViewer)viewers.get(i);
                    historyPopup.add(new HistoryAction(viewer.getTitle(), i + 1));
                    ++i;
                }
                popUp.add(historyPopup);
            }
        }
        popUp.show(showHere, x, y);
    }

    class HistoryAction
    extends AbstractAction {
        int viewerIndex;

        public HistoryAction(String name, int i) {
            super(name);
            this.viewerIndex = 0;
            this.viewerIndex = i;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.areNodesDefined()) {
                StationNode.this.createHistoryViewer(this.viewerIndex);
                return;
            }
            JOptionPane.showMessageDialog(null, "NaqsView has not received any state ofhealth data from: " + StationNode.this.getStationName() + "." + "\nTo define a bundle type, right click on individual cell.", "No Bundles Received", 1);
        }

        private boolean areNodesDefined() {
            ArrayList list = StationNode.this.getNodes();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                NaqsNode node = (NaqsNode)iter.next();
                if (node.getBundleType() <= 0) continue;
                return true;
            }
            return false;
        }
    }

    class ResetAction
    extends AbstractAction {
        JTable table;

        public ResetAction(JComponent showHere) {
            super("Reset");
            this.table = null;
            if (showHere instanceof JTable) {
                this.table = (JTable)showHere;
            }
        }

        public void actionPerformed(ActionEvent e) {
            Iterator iter = StationNode.this.nodes.iterator();
            while (iter.hasNext()) {
                DoubleNode node = (DoubleNode)iter.next();
                node.reset();
            }
            if (this.table != null) {
                this.table.repaint();
            }
        }
    }
}

