/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class TextViewer
extends JDialog {
    private boolean neverShown = true;
    private JEditorPane jta;

    public TextViewer(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.jta = new JTextPane();
        this.jta.setFont(new Font("MonoSpaced", 0, 12));
        this.jta.setEnabled(true);
        this.jta.setEditable(false);
        this.jta.setDisabledTextColor(Color.black);
        this.jta.setText("text not initialized");
        content.add((Component)new JScrollPane(this.jta), "Center");
        JButton okButton = new JButton(" OK ");
        JPanel okPanel = new JPanel(new FlowLayout(1, 0, 0));
        okButton.setMnemonic('O');
        okPanel.add(okButton);
        content.add((Component)okPanel, "South");
        okButton.addActionListener(new OkHandler());
        this.addKeyListener(new EscapeMonitor());
        this.pack();
    }

    public void setText(String text) {
        this.jta.setText(text);
    }

    public void loadFile(String filename) {
        File txtFile = new File(filename);
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            FileReader filer = new FileReader(txtFile);
            BufferedReader reader = new BufferedReader(filer);
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            this.setText(buffer.toString());
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            this.setText("Cannot find the requested file: " + txtFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            buffer.append("I/O Exception reading file " + txtFile.getAbsolutePath());
            buffer.append("\n\n" + ioe.getMessage());
            this.setText(buffer.toString());
        }
    }

    public void loadResource(String resource) {
        URL url = this.getClass().getResource(resource);
        try {
            this.jta.setPage(url);
        }
        catch (IOException e) {
            Log.report(this, 5, 2, "Failed to find help file " + resource);
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible && this.neverShown) {
            this.neverShown = false;
            int width = 600;
            int height = 350;
            this.setSize(width, height);
        }
        super.setVisible(isVisible);
    }

    class EscapeMonitor
    implements KeyListener {
        EscapeMonitor() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TextViewer.this.setVisible(false);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class OkHandler
    implements ActionListener {
        OkHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            TextViewer.this.setVisible(false);
        }
    }
}

