/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class AuthenticationSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 59;
    static final int OFFSET_TO_NUM_SFH = 5;
    static final int OFFSET_TO_BAD_SIGN = 9;
    static final int OFFSET_TO_BAD_STATUS = 11;
    static final int OFFSET_TO_MISS_SAMPLES = 13;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int FRAMES_BUILT_COL = 2;
    public static final int SIGN_ERRORS_COL = 3;
    public static final int MISSING_SOH_COL = 4;
    public static final int MISSING_DATA_COL = 5;

    public AuthenticationSohBundle() {
        super(59);
    }

    public AuthenticationSohBundle(byte[] buffer, int index) {
        super(buffer, index, 59);
    }

    public AuthenticationSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 59);
    }

    public AuthenticationSohBundle(int numSubf, int badSign, int badStatus, int missSamples) {
        super(59, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeInt(this.guts, 5, numSubf);
        LittleEndian.writeShort(this.guts, 9, (short)badSign);
        LittleEndian.writeShort(this.guts, 11, (short)badStatus);
        LittleEndian.writeShort(this.guts, 13, (short)missSamples);
    }

    public SohBundle createBundle() {
        return new AuthenticationSohBundle();
    }

    public int getNumSfh() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public int getNumInvSignature() {
        return LittleEndian.readShort(this.guts, 9);
    }

    public int getNumMissStatus() {
        return LittleEndian.readShort(this.guts, 11);
    }

    public int getNumMissSamples() {
        return LittleEndian.readShort(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new AuthenticationSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "aus";
    }

    public String getCsvTitle() {
        return "Authentication status for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%8d");
        sb.append("," + f.form(this.getNumSfh()));
        f = new Format("%5d");
        sb.append("," + f.form(this.getNumInvSignature()));
        sb.append("," + f.form(this.getNumMissStatus()));
        sb.append("," + f.form(this.getNumMissSamples()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getNumSfh());
            }
            case 3: {
                return new Integer(this.getNumInvSignature());
            }
            case 4: {
                return new Integer(this.getNumMissStatus());
            }
            case 5: {
                return new Integer(this.getNumMissSamples());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " FramesBuilt";
            }
            case 3: {
                return " SignErrors";
            }
            case 4: {
                return " MissingSoh";
            }
            case 5: {
                return " MissingData";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "Authentication Status";
    }
}

