/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class BurstBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 52;
    static final int OFFSET_TO_IP = 5;
    static final int OFFSET_TO_STATE = 9;
    static final int OFFSET_TO_GOOD = 10;
    static final int OFFSET_TO_BAD = 13;
    private static final int NUMBER_OF_COLUMNS = 7;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TRANS_IP_COL = 2;
    public static final int SLOT_STATE_COL = 3;
    public static final int BURST_STATE_COL = 4;
    public static final int GOOD_BURSTS_COL = 5;
    public static final int BAD_BURSTS_COL = 6;

    public BurstBundle() {
        super(52);
    }

    public BurstBundle(byte[] buffer, int index) {
        super(buffer, index, 52);
    }

    public BurstBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 52);
    }

    public SohBundle createBundle() {
        return new BurstBundle();
    }

    public int getSlotId() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public String getTxIp() {
        return this.getSlotIdName(this.getSlotId());
    }

    public int getSlotState() {
        return this.guts[9] & 3;
    }

    public int getBurstState() {
        return this.guts[9] >> 2 & 3;
    }

    public int getNumOfGoodBursts() {
        return LittleEndian.readUInt24(this.guts, 10);
    }

    public int getNumOfBadBursts() {
        return LittleEndian.readUInt24(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new BurstBundle(bytes, index);
    }

    public String getCsvName() {
        return "bxb";
    }

    public String getCsvTitle() {
        return "VSat: Burst for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%15s");
        sb.append("," + f.form(this.getTxIp()));
        f = new Format("%2d");
        sb.append("," + f.form(this.getSlotState()));
        sb.append("," + f.form(this.getBurstState()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getNumOfGoodBursts()));
        sb.append("," + f.form(this.getNumOfBadBursts()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getTxIp();
            }
            case 3: {
                return new Integer(this.getSlotState());
            }
            case 4: {
                return new Integer(this.getBurstState());
            }
            case 5: {
                return new Integer(this.getNumOfGoodBursts());
            }
            case 6: {
                return new Integer(this.getNumOfBadBursts());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " TransmitterIP";
            }
            case 3: {
                return " SlotState";
            }
            case 4: {
                return " BurstState";
            }
            case 5: {
                return " GoodBursts";
            }
            case 6: {
                return " BadBursts";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 7;
    }

    public String getName() {
        return "Burst SOH";
    }
}

