/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class EpochBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 53;
    static final int OFFSET_TO_TIME = 5;
    private static final int NUMBER_OF_COLUMNS = 3;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int NEXT_TIME_COL = 2;

    public EpochBundle() {
        super(53);
    }

    public EpochBundle(byte[] buffer, int index) {
        super(buffer, index, 53);
    }

    public EpochBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 53);
    }

    public int getEpochTime() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public SohBundle createBundle() {
        return new EpochBundle();
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new EpochBundle(bytes, index);
    }

    public String getCsvName() {
        return "epx";
    }

    public String getCsvTitle() {
        return "VSat: Epoch for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%12d");
        sb.append("," + f.form(this.getEpochTime()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getEpochTime());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " NextEpochTime";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 3;
    }

    public String getName() {
        return "Epoch";
    }
}

