/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class EventBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 24;
    static final int OFFSET_TO_ENDTIME = 5;
    static final int OFFSET_TO_CAUSE = 9;
    static final int OFFSET_TO_TRGFLGS = 10;
    private static final int NUMBER_OF_COLUMNS = 10;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int DURATION_COL = 2;
    public static final int TYPE_COL = 3;
    public static final int TRIGGER1_COL = 4;
    public static final int TRIGGER2_COL = 5;
    public static final int TRIGGER3_COL = 6;
    public static final int TRIGGER4_COL = 7;
    public static final int TRIGGER5_COL = 8;
    public static final int TRIGGER6_COL = 9;

    public EventBundle() {
        super(24);
    }

    public EventBundle(byte[] buffer, int index) {
        super(buffer, index, 24);
    }

    public EventBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 24);
    }

    public SohBundle createBundle() {
        return new EventBundle();
    }

    public long getEndTime() {
        return LittleEndian.readUInt(this.guts, 5);
    }

    public int getCause() {
        return this.guts[9];
    }

    public int getTriggerFlgs() {
        return this.guts[10];
    }

    public int getTrigger(int i) {
        return this.getTriggerFlgs() >> i & 1;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new EventBundle(bytes, index);
    }

    public String getCsvName() {
        return "elf";
    }

    public String getCsvTitle() {
        return "Event list for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%11d");
        sb.append("," + f.form(this.getEndTime()));
        f = new Format("%4d");
        sb.append("," + f.form(this.getCause()));
        f = new Format("%2d");
        int j = 0;
        while (j < 6) {
            sb.append("," + f.form(this.getTrigger(j)));
            ++j;
        }
        return sb.toString();
    }

    public String getCsvHeader() {
        return "StartTime(longsecs),StartTime(date-time),Duration,Type,Trigger1,Trigger2,Trigger3,Trigger4,Trigger5,Trigger6";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "Duration";
            }
            case 3: {
                return "Type";
            }
            case 4: {
                return "Trigger1";
            }
            case 5: {
                return "Trigger2";
            }
            case 6: {
                return "Trigger3";
            }
            case 7: {
                return "Trigger4";
            }
            case 8: {
                return "Trigger5";
            }
            case 9: {
                return "Trigger6";
            }
        }
        return "";
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "long";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "integer";
            }
            case 7: {
                return "integer";
            }
            case 8: {
                return "integer";
            }
            case 9: {
                return "integer";
            }
        }
        return "";
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Long(this.getEndTime());
            }
            case 3: {
                return new Integer(this.getCause());
            }
            case 4: {
                return new Integer(this.getTrigger(0));
            }
            case 5: {
                return new Integer(this.getTrigger(1));
            }
            case 6: {
                return new Integer(this.getTrigger(2));
            }
            case 7: {
                return new Integer(this.getTrigger(3));
            }
            case 8: {
                return new Integer(this.getTrigger(4));
            }
            case 9: {
                return new Integer(this.getTrigger(5));
            }
        }
        return null;
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public int getColumnCount() {
        return 10;
    }

    public String getName() {
        return "Event List";
    }
}

