/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class FastExternalSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 32;
    static final int OFFSET_TO_MASS_POS1 = 5;
    static final int OFFSET_TO_MASS_POS2 = 9;
    static final int OFFSET_TO_MASS_POS3 = 13;
    private static final Format f8p2 = new Format("%9.2f");
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int MASS_POS_1 = 2;
    public static final int MASS_POS_2 = 3;
    public static final int MASS_POS_3 = 4;

    public FastExternalSohBundle() {
        super(32);
    }

    public FastExternalSohBundle(byte[] buffer, int index) {
        super(buffer, index, 32);
    }

    public FastExternalSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 32);
    }

    public FastExternalSohBundle(float massPos1, float massPos2, float massPos3) {
        super(32, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, massPos1);
        LittleEndian.writeFloat(this.guts, 9, massPos2);
        LittleEndian.writeFloat(this.guts, 13, massPos3);
    }

    public SohBundle createBundle() {
        return new FastExternalSohBundle();
    }

    public float getMassPos1() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getMassPos2() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getMassPos3() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new FastExternalSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "fes";
    }

    public String getCsvTitle() {
        return "Fast external SOH";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append(", " + f8p2.form(this.getMassPos1()));
        sb.append(", " + f8p2.form(this.getMassPos2()));
        sb.append(", " + f8p2.form(this.getMassPos3()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getMassPos1());
            }
            case 3: {
                return new Double(this.getMassPos2());
            }
            case 4: {
                return new Double(this.getMassPos3());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return "   FSOH1";
            }
            case 3: {
                return "   FSOH2";
            }
            case 4: {
                return "   FSOH3";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: 
            case 3: 
            case 4: {
                thresholds[0] = -4.0;
                thresholds[1] = -1.0;
                thresholds[2] = 1.0;
                thresholds[3] = 4.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Fast External SOH";
    }
}

