/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class GpsLocationBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 13;
    static final int OFFSET_TO_LATITUDE = 5;
    static final int OFFSET_TO_LONGITUDE = 9;
    static final int OFFSET_TO_ELEVATION = 13;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int LATITUDE_COL = 2;
    public static final int LONGITUDE_COL = 3;
    public static final int ELEVATION_COL = 4;

    public GpsLocationBundle() {
        super(13);
    }

    public GpsLocationBundle(byte[] buffer, int index) {
        super(buffer, index, 13);
    }

    public GpsLocationBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 13);
    }

    public GpsLocationBundle(float latitude, float longitude, float elevation) {
        super(13, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, latitude);
        LittleEndian.writeFloat(this.guts, 9, longitude);
        LittleEndian.writeFloat(this.guts, 13, elevation);
    }

    public SohBundle createBundle() {
        return new GpsLocationBundle();
    }

    public float getLatitude() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getLongitude() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getElevation() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new GpsLocationBundle(bytes, index);
    }

    public String getCsvName() {
        return "loc";
    }

    public String getCsvTitle() {
        return "Gps Location SOH ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%10.4f");
        sb.append("," + f.form(this.getLatitude()));
        sb.append("," + f.form(this.getLongitude()));
        f = new Format("%10d");
        sb.append("," + f.form(Math.round(this.getElevation())));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getLatitude());
            }
            case 3: {
                return new Double(this.getLongitude());
            }
            case 4: {
                return new Double(this.getElevation());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " Latitude";
            }
            case 3: {
                return " Longitude";
            }
            case 4: {
                return " Elevation(deg)";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: {
                thresholds[0] = -90.0;
                thresholds[1] = -90.0;
                thresholds[2] = 90.0;
                thresholds[3] = 90.0;
                break;
            }
            case 3: {
                thresholds[0] = -360.0;
                thresholds[1] = -360.0;
                thresholds[2] = 360.0;
                thresholds[3] = 360.0;
                break;
            }
            case 4: {
                thresholds[0] = -180.0;
                thresholds[1] = -180.0;
                thresholds[2] = 180.0;
                thresholds[3] = 180.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "GPS Location";
    }
}

