/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class GpsTimeQualityBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 39;
    static final double COUNT_DURATION = 2.604166666666667E-7;
    static final int kusFineLockPeriod = 16;
    private static final int NUMBER_OF_COLUMNS = 10;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int GPS_ON_TIME_COL = 2;
    public static final int GPS_OFF_TIME_COL = 3;
    public static final int GPS_TIME_TO_LOCK_COL = 4;
    public static final int TIME_DIFF_AT_LOCK_COL = 5;
    public static final int VCXO_ERROR_COL = 6;
    public static final int TEMP_COMP_OFFSET_COL = 7;
    public static final int GPS_OFF_REASON_COL = 8;
    public static final int GPS_FINAL_MODE_COL = 9;

    public GpsTimeQualityBundle() {
        super(39);
    }

    public GpsTimeQualityBundle(byte[] buffer, int index) {
        super(buffer, index, 39);
    }

    public GpsTimeQualityBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 39);
    }

    public GpsTimeQualityBundle(int gpsOnTime, int gpsLastOffTime, int gpsTimeToLockSecs, int deltaTimeCounts, int vcxoOffset, int gpsOffReason, int finalGpsMode) {
        super(39, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeShort(this.guts, 5, (short)gpsOnTime);
        LittleEndian.writeShort(this.guts, 7, (short)gpsLastOffTime);
        LittleEndian.writeShort(this.guts, 9, (short)gpsTimeToLockSecs);
        LittleEndian.writeShort(this.guts, 11, (short)deltaTimeCounts);
        LittleEndian.writeShort(this.guts, 13, (short)vcxoOffset);
        this.guts[15] = (byte)gpsOffReason;
        this.guts[16] = (byte)finalGpsMode;
    }

    public GpsTimeQualityBundle(int gpsOnTime, int gpsLastOffTime, int gpsTimeToLockSecs, int deltaTimeCounts, int vcxoOffset, char gpsOffReason, char finalGpsMode) {
        this(gpsOnTime, gpsLastOffTime, gpsTimeToLockSecs, deltaTimeCounts, vcxoOffset, (int)gpsOffReason, (int)finalGpsMode);
    }

    public int getGpsOnTime() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public int getGpsLastOffTime() {
        return LittleEndian.readShort(this.guts, 7);
    }

    public int getGpsTimeToLockSecs() {
        return LittleEndian.readShort(this.guts, 9);
    }

    public int getDeltaTimeCounts() {
        return LittleEndian.readShort(this.guts, 11);
    }

    public int getVcxoOffset() {
        return LittleEndian.readShort(this.guts, 13);
    }

    public int getGpsOffReason() {
        return this.guts[15];
    }

    public int getFinalGpsMode() {
        return this.guts[16];
    }

    public int getVcxoError() {
        return this.getDeltaTimeCounts() / (this.getGpsLastOffTime() + this.getGpsTimeToLockSecs());
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new GpsTimeQualityBundle(bytes, index);
    }

    public SohBundle createBundle() {
        return new GpsTimeQualityBundle();
    }

    public String getCsvName() {
        return "gtq";
    }

    public String getCsvTitle() {
        return "GPS time quality for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%7d");
        sb.append("," + f.form(this.getGpsOnTime()));
        sb.append("," + f.form(this.getGpsLastOffTime()));
        sb.append("," + f.form(this.getGpsTimeToLockSecs()));
        double val = (double)this.getDeltaTimeCounts() * 2.604166666666667E-7 * 1000000.0;
        f = new Format("%11.1f");
        sb.append("," + f.form(val));
        f = new Format("%10.3f");
        sb.append("," + f.form(val /= (double)(this.getGpsLastOffTime() + this.getGpsTimeToLockSecs())));
        val = (double)this.getVcxoOffset() / 16.0;
        sb.append("," + f.form(val));
        f = new Format("%2d");
        sb.append("," + f.form(this.getGpsOffReason()));
        sb.append("," + f.form(this.getFinalGpsMode()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getGpsOnTime());
            }
            case 3: {
                return new Integer(this.getGpsLastOffTime());
            }
            case 4: {
                return new Integer(this.getGpsTimeToLockSecs());
            }
            case 5: {
                return new Double((double)this.getDeltaTimeCounts() * 2.604166666666667E-7 * 1000000.0);
            }
            case 6: {
                return new Double((double)this.getDeltaTimeCounts() * 2.604166666666667E-7 * 1000000.0 / (double)(this.getGpsLastOffTime() + this.getGpsTimeToLockSecs()));
            }
            case 7: {
                return new Double((double)this.getVcxoOffset() / 16.0);
            }
            case 8: {
                return new Integer(this.getGpsOffReason());
            }
            case 9: {
                return new Integer(this.getFinalGpsMode());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "integer";
            }
            case 9: {
                return "integer";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "GPSOnTime";
            }
            case 3: {
                return "GPSOffTime";
            }
            case 4: {
                return "GPSTimeToLock";
            }
            case 5: {
                return "TimeDiffAtLock";
            }
            case 6: {
                return "VCXOError";
            }
            case 7: {
                return "TempCompOffset";
            }
            case 8: {
                return "GPSOffReason";
            }
            case 9: {
                return "GPSFinalMode";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 10;
    }

    public String getName() {
        return "GPS Time Quality";
    }
}

