/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class InstrumentSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 34;
    public static final int OFFSET_TO_BATTERY = 5;
    public static final int OFFSET_TO_TEMPTUR = 9;
    public static final int OFFSET_TO_RADIOSNR = 13;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int BATT_VOLTAGE_COL = 2;
    public static final int VCXO_TEMP_COL = 3;
    public static final int RADIO_SNR_COL = 4;

    public InstrumentSohBundle() {
        super(34);
    }

    public InstrumentSohBundle(byte[] buffer, int index) {
        super(buffer, index, 34);
    }

    public InstrumentSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 34);
    }

    public InstrumentSohBundle(float battery, float temperature) {
        super(34, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, battery);
        LittleEndian.writeFloat(this.guts, 9, temperature);
    }

    public SohBundle createBundle() {
        return new InstrumentSohBundle();
    }

    public float getBatVolts() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getTemperature() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getRadioSNR() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new InstrumentSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "hrd";
    }

    public String getCsvTitle() {
        return "HRD Slow Internal SOH for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format form = new Format("%10.2f");
        sb.append("," + form.form(this.getBatVolts()));
        sb.append("," + form.form(this.getTemperature()));
        sb.append("," + form.form(this.getRadioSNR()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getBatVolts());
            }
            case 3: {
                return new Double(this.getTemperature());
            }
            case 4: {
                return new Double(this.getRadioSNR());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " BatteryVoltage";
            }
            case 3: {
                return " VCXOTemp";
            }
            case 4: {
                return " RadioSNR";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: {
                thresholds[0] = 10.0;
                thresholds[1] = 11.0;
                thresholds[2] = 18.0;
                thresholds[3] = 19.0;
                break;
            }
            case 3: {
                thresholds[0] = -20.0;
                thresholds[1] = -10.0;
                thresholds[2] = 30.0;
                thresholds[3] = 45.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "HRD Slow Internal SOH";
    }
}

