/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class LibraEnvironSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 49;
    static final int OFFSET_TO_EXTSOH1 = 5;
    static final int OFFSET_TO_EXTSOH2 = 9;
    static final int OFFSET_TO_EXTSOH3 = 13;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int SOH_1 = 2;
    public static final int SOH_2 = 3;
    public static final int SOH_3 = 4;

    public LibraEnvironSohBundle() {
        super(49);
    }

    public LibraEnvironSohBundle(byte[] buffer, int index) {
        super(buffer, index, 49);
    }

    public LibraEnvironSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 49);
    }

    public LibraEnvironSohBundle(float extSoh1, float extSoh2, float extSoh3) {
        super(49, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, extSoh1);
        LittleEndian.writeFloat(this.guts, 9, extSoh2);
        LittleEndian.writeFloat(this.guts, 13, extSoh3);
    }

    public SohBundle createBundle() {
        return new LibraEnvironSohBundle();
    }

    public float getExtSoh1() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getExtSoh2() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getExtSoh3() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LibraEnvironSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "les";
    }

    public String getCsvTitle() {
        return "VSat: Libra Environment Soh for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        float val = this.getExtSoh1();
        val = Math.round(val * 1000.0f);
        Format f = new Format("%8.3f");
        sb.append("," + f.form(val /= 1000.0f));
        val = this.getExtSoh2();
        val = Math.round(val * 100.0f);
        sb.append("," + f.form(val /= 100.0f));
        val = this.getExtSoh3();
        val = Math.round(val * 100.0f);
        sb.append("," + f.form(val /= 100.0f));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getExtSoh1());
            }
            case 3: {
                return new Double(this.getExtSoh2());
            }
            case 4: {
                return new Double(this.getExtSoh3());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "ExternalSoh1";
            }
            case 3: {
                return "ExternalSoh2";
            }
            case 4: {
                return "ExternalSoh3";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: 
            case 3: 
            case 4: {
                thresholds[0] = 0.0;
                thresholds[1] = 1.0;
                thresholds[2] = 4.0;
                thresholds[3] = 5.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Libra Environment SOH";
    }
}

