/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Float16;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class LibraInstrSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 48;
    static final int OFFSET_TO_FERROR = 5;
    static final int OFFSET_TO_SSPBT = 7;
    static final int OFFSET_TO_CONTRT = 9;
    static final int OFFSET_TO_MODEMT = 11;
    static final int OFFSET_TO_BATV = 13;
    private static final int NUMBER_OF_COLUMNS = 7;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int FREQ_ERROR_COL = 2;
    public static final int SSPB_TEMP_COL = 3;
    public static final int CONTROLLER_TEMP_COL = 4;
    public static final int MODEM_TEMP_COL = 5;
    public static final int BATTERY_VOLTAGE_COL = 6;

    public LibraInstrSohBundle() {
        super(48);
    }

    public LibraInstrSohBundle(byte[] buffer, int index) {
        super(buffer, index, 48);
    }

    public LibraInstrSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 48);
    }

    public LibraInstrSohBundle(int freqError, double sspbTemp, double controllerTemp, double modemTemp, double batteryVolts) {
        super(48, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeShort(this.guts, 5, (short)freqError);
        this.putF16Val(7, sspbTemp);
        this.putF16Val(9, controllerTemp);
        this.putF16Val(11, modemTemp);
        this.putF16Val(13, batteryVolts);
    }

    public SohBundle createBundle() {
        return new LibraInstrSohBundle();
    }

    private void putF16Val(int offset, double val) {
        LittleEndian.writeShort(this.guts, offset, (short)Float16.floatToBits((float)val));
    }

    private float getF16Val(int offset) {
        return Float16.bitsToFloat(LittleEndian.readShort(this.guts, offset));
    }

    public float getTenMHzFreqError() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public float getSspbTemp() {
        return this.getF16Val(7);
    }

    public float getWwTemp() {
        return this.getControllerTemp();
    }

    public float getControllerTemp() {
        return this.getF16Val(9);
    }

    public float getTxTemp() {
        return this.getModemTemp();
    }

    public float getModemTemp() {
        return this.getF16Val(11);
    }

    public float getBatVolt() {
        return this.getF16Val(13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LibraInstrSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "lis";
    }

    public String getCsvTitle() {
        return "VSat: Libra Instrument Soh for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%6.0f");
        sb.append("," + f.form(this.getTenMHzFreqError()));
        f = new Format("%8.2f");
        sb.append("," + f.form(this.getSspbTemp()));
        sb.append("," + f.form(this.getControllerTemp()));
        sb.append("," + f.form(this.getModemTemp()));
        sb.append("," + f.form(this.getBatVolt()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getTenMHzFreqError());
            }
            case 3: {
                return new Double(this.getSspbTemp());
            }
            case 4: {
                return new Double(this.getControllerTemp());
            }
            case 5: {
                return new Double(this.getModemTemp());
            }
            case 6: {
                return new Double(this.getBatVolt());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "double";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " 10MHzFreqError";
            }
            case 3: {
                return " SSPBTemp";
            }
            case 4: {
                return " ControllerTemp";
            }
            case 5: {
                return " ModemTemp";
            }
            case 6: {
                return " BatteryVoltage";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: {
                thresholds[0] = -5000.0;
                thresholds[1] = -1000.0;
                thresholds[2] = 1000.0;
                thresholds[3] = 5000.0;
                break;
            }
            case 3: {
                thresholds[0] = -15.0;
                thresholds[1] = -10.0;
                thresholds[2] = 50.0;
                thresholds[3] = 55.0;
                break;
            }
            case 4: 
            case 5: {
                thresholds[0] = -10.0;
                thresholds[1] = -5.0;
                thresholds[2] = 50.0;
                thresholds[3] = 65.0;
                break;
            }
            case 6: {
                thresholds[0] = 11.0;
                thresholds[1] = 11.5;
                thresholds[2] = 15.0;
                thresholds[3] = 16.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getName() {
        return "Libra Instrument SOH";
    }
}

