/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class LibraSerialDataBytesBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 57;
    static final int OFFSET_TO_PORT = 5;
    static final int OFFSET_TO_READ = 6;
    static final int OFFSET_TO_WRITTEN = 10;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int PORT_COL = 2;
    public static final int BYTES_READ_COL = 3;
    public static final int BYTES_WRITTEN_COL = 4;

    public LibraSerialDataBytesBundle() {
        super(57);
    }

    public LibraSerialDataBytesBundle(byte[] buffer, int index) {
        super(buffer, index, 57);
    }

    public LibraSerialDataBytesBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 57);
    }

    public SohBundle createBundle() {
        return new LibraSerialDataBytesBundle();
    }

    public int getPort() {
        return this.guts[5];
    }

    public void setPort(int port) {
        if (this.emptyBundle()) {
            return;
        }
        Integer p = new Integer(port);
        byte[] bytes = new byte[17];
        int index = 0;
        while (index < 17) {
            bytes[index] = index != 5 ? this.guts[index] : p.byteValue();
            ++index;
        }
        this.guts = bytes;
    }

    public int getBytesRead() {
        return LittleEndian.readInt(this.guts, 6);
    }

    public int getBytesWritten() {
        return LittleEndian.readInt(this.guts, 10);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LibraSerialDataBytesBundle(bytes, index);
    }

    public String getCsvName() {
        return "sdb";
    }

    public String getCsvTitle() {
        return "VSat: Serial Data Bytes for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%3d");
        sb.append("," + f.form(this.getPort()));
        f = new Format("%12d");
        sb.append("," + f.form(this.getBytesRead()));
        sb.append("," + f.form(this.getBytesWritten()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getPort());
            }
            case 3: {
                return new Integer(this.getBytesRead());
            }
            case 4: {
                return new Integer(this.getBytesWritten());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "PortNumber";
            }
            case 3: {
                return "BytesRead";
            }
            case 4: {
                return "BytesWritten";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public boolean hasPort() {
        return true;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Serial Data Bytes";
    }
}

