/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Float16;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class LibraSystemTimeQualityBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 55;
    static final int OFFSET_TO_QUA = 5;
    static final int OFFSET_TO_MODE = 9;
    static final int OFFSET_TO_DISP = 11;
    static final int OFFSET_TO_VEL = 13;
    static final int OFFSET_TO_COMP = 15;
    static final String[] pllMode = new String[]{" ", "FINE_LOCK", "COARSE_LOCK", "NO_LOCK"};
    private static final int NUMBER_OF_COLUMNS = 7;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int SYSTEM_TIME_COL = 2;
    public static final int PLL_MODE_COL = 3;
    public static final int TIME_DISPLACEMENT_COL = 4;
    public static final int TIME_VELOCITY_COL = 5;
    public static final int CURRENT_COMP_COL = 6;

    public LibraSystemTimeQualityBundle() {
        super(55);
    }

    public LibraSystemTimeQualityBundle(byte[] buffer, int index) {
        super(buffer, index, 55);
    }

    public LibraSystemTimeQualityBundle(SohBundle rhs) throws InvalidInputException {
        super(rhs, 55);
    }

    public SohBundle createBundle() {
        return new LibraSystemTimeQualityBundle();
    }

    public int getTimeQualityVal() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public String getTimeQuality() {
        int quality = this.getTimeQualityVal();
        if (quality == -10) {
            return new String("UNKNOWN");
        }
        if (quality == -1) {
            return new String("NOT_GOOD");
        }
        if (quality >= 0) {
            return String.valueOf(quality);
        }
        return new String("-11");
    }

    public String getPllMode() {
        return pllMode[this.getPllModeVal()];
    }

    public int getPllModeVal() {
        return LittleEndian.readShort(this.guts, 9);
    }

    public int getDisplacement() {
        return LittleEndian.readShort(this.guts, 11);
    }

    public int getVelocity() {
        return LittleEndian.readShort(this.guts, 13);
    }

    public float getCompensation() {
        return Float16.bitsToFloat(LittleEndian.readShort(this.guts, 15));
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LibraSystemTimeQualityBundle(bytes, index);
    }

    public String getCsvName() {
        return "lsq";
    }

    public String getCsvTitle() {
        return "VSat: Libra System Time Quality for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%12d");
        sb.append("," + f.form(this.getTimeQualityVal()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getPllModeVal()));
        sb.append("," + f.form(this.getDisplacement()));
        sb.append("," + f.form(this.getVelocity()));
        f = new Format("%12.6f");
        sb.append("," + f.form(this.getCompensation()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 6;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getTimeQualityVal());
            }
            case 3: {
                return new Integer(this.getPllModeVal());
            }
            case 4: {
                return new Integer(this.getDisplacement());
            }
            case 5: {
                return new Integer(this.getVelocity());
            }
            case 6: {
                return new Double(this.getCompensation());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "double";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "SystemTimeQuality";
            }
            case 3: {
                return "PLLmode";
            }
            case 4: {
                return "TimeDisplacement";
            }
            case 5: {
                return "TimeVelocity";
            }
            case 6: {
                return "CurrentCompensation";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 7;
    }

    public String getName() {
        return "Libra System Time Quality";
    }
}

