/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class MinMaxBundle
extends SohBundle {
    static final int OFFSET_TO_MIN1INTRVL = 5;
    static final int OFFSET_TO_MAX1INTRVL = 8;
    static final int OFFSET_TO_MIN2INTRVL = 11;
    static final int OFFSET_TO_MAX2INTRVL = 14;
    private static final int NUMBER_OF_COLUMNS = 4;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int MIN_COL = 2;
    public static final int MAX_COL = 3;

    public MinMaxBundle(int bundleType) {
        super(bundleType);
    }

    public MinMaxBundle(byte[] buffer, int index, int bundleType) {
        super(buffer, index, bundleType);
    }

    public MinMaxBundle(SohBundle bundle, int bundleType) throws InvalidInputException {
        super(bundle, bundleType);
    }

    public int getMin1Interval() {
        return LittleEndian.readInt24(this.guts, 5);
    }

    public int getMax1Interval() {
        return LittleEndian.readInt24(this.guts, 8);
    }

    public int getMin2Interval() {
        return LittleEndian.readInt24(this.guts, 11);
    }

    public int getMax2Interval() {
        return LittleEndian.readInt24(this.guts, 14);
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%11d");
        sb.append("," + f.form(this.getMin1Interval()));
        sb.append("," + f.form(this.getMax1Interval()));
        sb.append("\n");
        sb.append("           ,                         ," + f.form(this.getMin2Interval()));
        sb.append("," + f.form(this.getMax2Interval()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " Min";
            }
            case 3: {
                return " Max";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 4;
    }
}

