/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class NmxBusRequestBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 64;
    static final int OFFSET_TO_SERVERID = 5;
    static final int OFFSET_TO_REQUESTS = 7;
    static final int OFFSET_TO_PERMITS = 10;
    static final int OFFSET_TO_DENIALS = 13;
    static final int OFFSET_TO_SPARE = 16;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int INSTRUMENT_ID_COL = 2;
    public static final int NUM_REQUESTS_SENT_COL = 3;
    public static final int NUM_PERMITS_REC_COL = 4;
    public static final int NUM_DENIALS_REC_COL = 5;

    public NmxBusRequestBundle() {
        super(64);
    }

    public NmxBusRequestBundle(byte[] buffer, int index) {
        super(buffer, index, 64);
    }

    public NmxBusRequestBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 64);
    }

    public SohBundle createBundle() {
        return new NmxBusRequestBundle();
    }

    public int getSlotId() {
        return LittleEndian.readUShort(this.guts, 5);
    }

    public String getTimeServerName() {
        return this.getSlotIdName(this.getSlotId());
    }

    public int getRequestCount() {
        return LittleEndian.readUInt24(this.guts, 7);
    }

    public int getPermitCount() {
        return LittleEndian.readUInt24(this.guts, 10);
    }

    public int getDenialCount() {
        return LittleEndian.readUInt24(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new NmxBusRequestBundle(bytes, index);
    }

    public String getCsvName() {
        return "nbr";
    }

    public String getCsvTitle() {
        return "NMXbus Request";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%8s");
        sb.append("," + f.form(this.getTimeServerName()));
        f = new Format("%12d");
        sb.append("," + f.form(this.getRequestCount()));
        sb.append("," + f.form(this.getPermitCount()));
        sb.append("," + f.form(this.getDenialCount()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getTimeServerName();
            }
            case 3: {
                return new Integer(this.getRequestCount());
            }
            case 4: {
                return new Integer(this.getPermitCount());
            }
            case 5: {
                return new Integer(this.getDenialCount());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "Instrument ID";
            }
            case 3: {
                return "#Requests Sent";
            }
            case 4: {
                return "#Permits Rec";
            }
            case 5: {
                return "#Denials Rec";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "NMX Bus Request";
    }
}

