/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class NmxBusRxBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 65;
    static final int OFFSET_TO_RXPKTS = 5;
    static final int OFFSET_TO_RXBYTES = 9;
    static final int OFFSET_TO_OVERRUN = 13;
    static final int OFFSET_TO_HDLCERR = 15;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int NUM_GOOD_MSGS_COL = 2;
    public static final int NUM_BYTES_REC_COL = 3;
    public static final int NUM_RX_OVERRUNS_COL = 4;
    public static final int NUM_HDLC_ERRORS_COL = 5;

    public NmxBusRxBundle() {
        super(65);
    }

    public NmxBusRxBundle(byte[] buffer, int index) {
        super(buffer, index, 65);
    }

    public NmxBusRxBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 65);
    }

    public SohBundle createBundle() {
        return new NmxBusRxBundle();
    }

    public int getRxPackets() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public int getRxBytes() {
        return LittleEndian.readInt(this.guts, 9);
    }

    public int getRxOverruns() {
        return LittleEndian.readUShort(this.guts, 13);
    }

    public int getHdlcErrors() {
        return LittleEndian.readUShort(this.guts, 15);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new NmxBusRxBundle(bytes, index);
    }

    public String getCsvName() {
        return "nbx";
    }

    public String getCsvTitle() {
        return "NMXbus Rx";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%14d");
        sb.append("," + f.form(this.getRxPackets()));
        sb.append("," + f.form(this.getRxBytes()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getRxOverruns()));
        sb.append("," + f.form(this.getHdlcErrors()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getRxPackets());
            }
            case 3: {
                return new Integer(this.getRxBytes());
            }
            case 4: {
                return new Integer(this.getRxOverruns());
            }
            case 5: {
                return new Integer(this.getHdlcErrors());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "#Good Msgs Rec";
            }
            case 3: {
                return "#Bytes Rec";
            }
            case 4: {
                return "#Rx FIFO Overruns";
            }
            case 5: {
                return "#HDLC Errors";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "NMX Bus Rx";
    }
}

