/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class SerialPortErrorsBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 43;
    static final int OFFSET_TO_PORTNUM = 5;
    static final int OFFSET_TO_OVERRUN = 6;
    static final int OFFSET_TO_FRAMERR = 10;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int PORT_COL = 2;
    public static final int OVERRUNS_COL = 3;
    public static final int FRAME_ERRORS_COL = 4;

    public SohBundle createBundle() {
        return new SerialPortErrorsBundle();
    }

    public SerialPortErrorsBundle() {
        super(43);
    }

    public SerialPortErrorsBundle(byte[] buffer, int index) {
        super(buffer, index, 43);
    }

    public SerialPortErrorsBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 43);
    }

    public SerialPortErrorsBundle(int portNum, int numberOverrunErrors, int numberFrameErrors) {
        super(43, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)portNum;
        LittleEndian.writeInt(this.guts, 6, numberOverrunErrors);
        LittleEndian.writeInt(this.guts, 10, numberFrameErrors);
    }

    public int getPort() {
        return this.guts[5];
    }

    public void setPort(int port) {
        if (this.emptyBundle()) {
            return;
        }
        Integer p = new Integer(port);
        byte[] bytes = new byte[17];
        int index = 0;
        while (index < 17) {
            bytes[index] = index != 5 ? this.guts[index] : p.byteValue();
            ++index;
        }
        this.guts = bytes;
    }

    public boolean hasPort() {
        return true;
    }

    public long getOverrunErrors() {
        return LittleEndian.readUInt(this.guts, 6);
    }

    public long getFrameErrors() {
        return LittleEndian.readUInt(this.guts, 10);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new SerialPortErrorsBundle(bytes, index);
    }

    public String getCsvName() {
        return "spe";
    }

    public String getCsvTitle() {
        return "RM4 serial port errors for Instrument: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%3d");
        sb.append("," + f.form(this.getPort()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getOverrunErrors()));
        sb.append("," + f.form(this.getFrameErrors()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getPort());
            }
            case 3: {
                return new Long(this.getOverrunErrors());
            }
            case 4: {
                return new Long(this.getFrameErrors());
            }
        }
        return null;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "Port";
            }
            case 3: {
                return "OverRuns";
            }
            case 4: {
                return "FrameErrors";
            }
        }
        return "";
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "long";
            }
            case 4: {
                return "long";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        return 0;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Serial Port Error";
    }
}

