/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class SlowExternalSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 33;
    public static final int OFFSET_TO_SOH1 = 5;
    public static final int OFFSET_TO_SOH2 = 9;
    public static final int OFFSET_TO_SOH3 = 13;
    private static final Format f10p2 = new Format("%10.2f");
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int SOH_1 = 2;
    public static final int SOH_2 = 3;
    public static final int SOH_3 = 4;

    public SlowExternalSohBundle() {
        super(33);
    }

    public SlowExternalSohBundle(byte[] buffer, int index) {
        super(buffer, index, 33);
    }

    public SlowExternalSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 33);
    }

    public SlowExternalSohBundle(float soh1, float soh2, float soh3) {
        super(33, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, soh1);
        LittleEndian.writeFloat(this.guts, 9, soh2);
        LittleEndian.writeFloat(this.guts, 13, soh3);
    }

    public SohBundle createBundle() {
        return new SlowExternalSohBundle();
    }

    public float getSoh1() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getSoh2() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getSoh3() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new SlowExternalSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "ses";
    }

    public String getCsvTitle() {
        return "Slow external SOH";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append("," + f10p2.form(this.getSoh1()));
        sb.append("," + f10p2.form(this.getSoh2()));
        sb.append("," + f10p2.form(this.getSoh3()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getSoh1());
            }
            case 3: {
                return new Double(this.getSoh2());
            }
            case 4: {
                return new Double(this.getSoh3());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "SOH1";
            }
            case 3: {
                return "SOH2";
            }
            case 4: {
                return "SOH3";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: 
            case 3: 
            case 4: {
                thresholds[0] = -4.0;
                thresholds[1] = -1.0;
                thresholds[2] = 1.0;
                thresholds[3] = 4.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Slow External SOH";
    }
}

