/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class TimeServerGpsBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 62;
    static final int OFFSET_TO_STATUS = 5;
    static final int OFFSET_TO_VISIBLE = 6;
    static final int OFFSET_TO_TRACKED = 7;
    static final int OFFSET_TO_UTCDIFF = 8;
    static final int OFFSET_TO_CLOCKBIAS = 9;
    static final int OFFSET_TO_FREQBIAS = 11;
    static final int OFFSET_TO_RECVTEMP = 13;
    static final int OFFSET_TO_ANTENNAV = 15;
    public static final String[] trackingMode = new String[]{"initializing (0)", "initializing (1)", "bad geometry", "acquiring satellites", "position hold", "propagate mode", "2D fix", "3D fix"};
    public static final String[] antennaStatus = new String[]{"OK", "overcurrent", "not connected", "reserved"};
    private static final int NUMBER_OF_COLUMNS = 14;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TRACK_MODE_COL = 2;
    public static final int AUTO_SURVEY_MODE_COL = 3;
    public static final int INSUFF_VIS_SATS_COL = 4;
    public static final int ANTENNA_STATUS_COL = 5;
    public static final int ENGINE_POWERED_COL = 6;
    public static final int NUM_VIS_SATS_COL = 7;
    public static final int NUM_TRACKED_SATS_COL = 8;
    public static final int UTC_OFFSET_COL = 9;
    public static final int CLOCK_BIAS_COL = 10;
    public static final int FREQ_BIAS_COL = 11;
    public static final int REC_TEMP_COL = 12;
    public static final int ANTENNA_VOLTAGE_COL = 13;

    public TimeServerGpsBundle() {
        super(62);
    }

    public TimeServerGpsBundle(byte[] buffer, int index) {
        super(buffer, index, 62);
    }

    public TimeServerGpsBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 62);
    }

    public SohBundle createBundle() {
        return new TimeServerGpsBundle();
    }

    public int getClockBias() {
        return LittleEndian.readShort(this.guts, 9);
    }

    public int getFreqBias() {
        return LittleEndian.readUShort(this.guts, 11);
    }

    public double getReceiverTemp() {
        return LittleEndian.readFloat16(this.guts, 13);
    }

    public double getAntennaVoltage() {
        return LittleEndian.readFloat16(this.guts, 15);
    }

    public int getStatusBits() {
        return this.guts[5] & 0xFF;
    }

    public int getVisibleCount() {
        return this.guts[6];
    }

    public int getTrackedCount() {
        return this.guts[7];
    }

    public int getUtcOffsetSec() {
        return this.guts[8];
    }

    public int getTrackingModeNum() {
        return this.getStatusBits() >> 5 & 7;
    }

    public String getTrackingMode() {
        return trackingMode[this.getTrackingModeNum()];
    }

    public int getAntennaStatusNum() {
        return this.getStatusBits() >> 1 & 3;
    }

    public String getAntennaStatus() {
        return antennaStatus[this.getAntennaStatusNum()];
    }

    public boolean isEnginePowered() {
        return (this.getStatusBits() & 1) != 0;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new TimeServerGpsBundle(bytes, index);
    }

    public int getAutoSurveyModeNum() {
        return this.getStatusBits() >> 4 & 1;
    }

    public int getInsufficientVisSatellitesNum() {
        return this.getStatusBits() >> 3 & 1;
    }

    public int getEnginePoweredNum() {
        return this.getStatusBits() & 1;
    }

    public String getCsvName() {
        return "tsm";
    }

    public String getCsvTitle() {
        return "TimeServer M12GPS";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format form = new Format("%2d");
        sb.append("," + form.form(this.getTrackingModeNum()));
        sb.append("," + form.form(this.getAutoSurveyModeNum()));
        sb.append("," + form.form(this.getInsufficientVisSatellitesNum()));
        sb.append("," + form.form(this.getAntennaStatusNum()));
        sb.append("," + form.form(this.getEnginePoweredNum()));
        form = new Format("%6d");
        sb.append("," + form.form(this.getVisibleCount()));
        sb.append("," + form.form(this.getTrackedCount()));
        sb.append("," + form.form(this.getUtcOffsetSec()));
        sb.append("," + form.form(this.getClockBias()));
        form = new Format("%10d");
        sb.append("," + form.form(this.getFreqBias()));
        form = new Format("%10.2f");
        sb.append("," + form.form(this.getReceiverTemp()));
        sb.append("," + form.form(this.getAntennaVoltage()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getTrackingModeNum());
            }
            case 3: {
                return new Integer(this.getAutoSurveyModeNum());
            }
            case 4: {
                return new Integer(this.getInsufficientVisSatellitesNum());
            }
            case 5: {
                return new Integer(this.getAntennaStatusNum());
            }
            case 6: {
                return new Integer(this.getEnginePoweredNum());
            }
            case 7: {
                return new Integer(this.getVisibleCount());
            }
            case 8: {
                return new Integer(this.getTrackedCount());
            }
            case 9: {
                return new Integer(this.getUtcOffsetSec());
            }
            case 10: {
                return new Integer(this.getClockBias());
            }
            case 11: {
                return new Integer(this.getFreqBias());
            }
            case 12: {
                return new Double(this.getReceiverTemp());
            }
            case 13: {
                return new Double(this.getAntennaVoltage());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "integer";
            }
            case 7: {
                return "integer";
            }
            case 8: {
                return "integer";
            }
            case 9: {
                return "integer";
            }
            case 10: {
                return "integer";
            }
            case 11: {
                return "integer";
            }
            case 12: {
                return "double";
            }
            case 13: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 0;
            }
            case 11: {
                return 0;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "TrackingMode";
            }
            case 3: {
                return "AutoSurveyMode";
            }
            case 4: {
                return "InsufficientVisSats";
            }
            case 5: {
                return "AntennaStatus";
            }
            case 6: {
                return "EnginePowered";
            }
            case 7: {
                return "#VisibleSatellites";
            }
            case 8: {
                return "#TrackedSatellites";
            }
            case 9: {
                return "UTC Offset(s)";
            }
            case 10: {
                return "ClockBias(ns)";
            }
            case 11: {
                return "FreqBias(Hz)";
            }
            case 12: {
                return "RecieverTemp(deg)";
            }
            case 13: {
                return "AntennaVoltage(V)";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 14;
    }

    public String getName() {
        return "Time Server M12 GPS";
    }
}

