/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class TimeServerInstBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 60;
    static final int OFFSET_TO_TEMPERATURE = 5;
    static final int OFFSET_TO_SUPPLYVOLTS = 7;
    static final int OFFSET_TO_BUSVOLTAGE = 9;
    static final int OFFSET_TO_ANALOGVOLTS = 11;
    static final int OFFSET_TO_STATUSBITS = 13;
    static final int OFFSET_TO_UPTIME = 14;
    private static final int NUMBER_OF_COLUMNS = 8;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TEMPERATURE_COL = 2;
    public static final int SUPPLY_VOLTAGE_COL = 3;
    public static final int BUS_VOLTAGE_COL = 4;
    public static final int ANALOG_VOLTAGE_COL = 5;
    public static final int STATUS_COL = 6;
    public static final int UPTIME_COL = 7;

    public TimeServerInstBundle() {
        super(60);
    }

    public TimeServerInstBundle(byte[] buffer, int index) {
        super(buffer, index, 60);
    }

    public TimeServerInstBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 60);
    }

    public SohBundle createBundle() {
        return new TimeServerInstBundle();
    }

    public double getTemperature() {
        return LittleEndian.readFloat16(this.guts, 5);
    }

    public double getSupplyVoltage() {
        return LittleEndian.readFloat16(this.guts, 7);
    }

    public double getBusVoltage() {
        return LittleEndian.readFloat16(this.guts, 9);
    }

    public double getAnalogInput() {
        return LittleEndian.readFloat16(this.guts, 11);
    }

    public int getUptimeMinutes() {
        return LittleEndian.readUInt24(this.guts, 14);
    }

    public int getUptimeSeconds() {
        return 60 * this.getUptimeMinutes();
    }

    public int getStatusBits() {
        return this.guts[13] & 0xFF;
    }

    public boolean isBusTermEnabled() {
        return (this.getStatusBits() & 1) != 0;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new TimeServerInstBundle(bytes, index);
    }

    public String getCsvName() {
        return "tsi";
    }

    public String getCsvTitle() {
        return "TimeServer Instrument: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format form = new Format("%6.3f");
        sb.append("," + form.form(this.getTemperature()));
        form = new Format("%6.2f");
        sb.append("," + form.form(this.getSupplyVoltage()));
        sb.append("," + form.form(this.getBusVoltage()));
        sb.append("," + form.form(this.getAnalogInput()));
        form = new Format("%6d");
        sb.append("," + form.form(this.getStatusBits()));
        form = new Format("%12d");
        sb.append("," + form.form(this.getUptimeMinutes()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getTemperature());
            }
            case 3: {
                return new Double(this.getSupplyVoltage());
            }
            case 4: {
                return new Double(this.getBusVoltage());
            }
            case 5: {
                return new Double(this.getAnalogInput());
            }
            case 6: {
                return new Integer(this.getStatusBits());
            }
            case 7: {
                return new Integer(this.getUptimeMinutes());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "integer";
            }
            case 7: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "Temperature";
            }
            case 3: {
                return "SupplyVoltage";
            }
            case 4: {
                return "BusVoltage";
            }
            case 5: {
                return "AnalogVoltage";
            }
            case 6: {
                return "Status";
            }
            case 7: {
                return "Uptime(min)";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: {
                thresholds[0] = -10.0;
                thresholds[1] = -5.0;
                thresholds[2] = 50.0;
                thresholds[3] = 55.0;
                break;
            }
            case 3: {
                thresholds[0] = 3.1;
                thresholds[1] = 3.2;
                thresholds[2] = 3.4;
                thresholds[3] = 3.5;
                break;
            }
            case 4: {
                thresholds[0] = 9.5;
                thresholds[1] = 10.5;
                thresholds[2] = 28.0;
                thresholds[3] = 30.0;
                break;
            }
            case 5: {
                thresholds[0] = -5.0;
                thresholds[1] = -2.0;
                thresholds[2] = 2.0;
                thresholds[3] = 5.0;
            }
        }
        return thresholds;
    }

    public boolean isColorColumn(int index) {
        switch (index) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return false;
            }
        }
        return false;
    }

    public int getColumnCount() {
        return 8;
    }

    public String getName() {
        return "TimeServer Instrument";
    }
}

