/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class CSVFile {
    private StreamTokenizer stream = null;
    private BufferedReader reader = null;

    public CSVFile(Reader _reader) throws IOException {
        this.reader = new BufferedReader(_reader);
        this.stream = new StreamTokenizer(this.reader);
        this.reader.mark(1);
        this.stream.resetSyntax();
        this.stream.lowerCaseMode(false);
        this.stream.slashStarComments(false);
        this.stream.slashSlashComments(false);
        this.stream.eolIsSignificant(false);
        this.stream.wordChars(0, 255);
        this.stream.ordinaryChar(44);
        this.stream.ordinaryChar(10);
        this.stream.whitespaceChars(44, 44);
        this.stream.whitespaceChars(10, 10);
    }

    public CSVFile(String fileName) throws IOException {
        this(new FileReader(fileName));
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    public String getStringToken() throws IOException {
        return this.getNextToken();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLineIgnoringCommas() throws IOException {
        String result;
        this.stream.wordChars(44, 44);
        try {
            result = this.getNextToken();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stream.ordinaryChar(44);
            this.stream.whitespaceChars(44, 44);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.stream.ordinaryChar(44);
            this.stream.whitespaceChars(44, 44);
            return result;
        }
    }

    public double getDoubleToken() throws IOException, NumberFormatException {
        return Double.parseDouble(this.getNextToken());
    }

    public int getIntToken() throws IOException, NumberFormatException {
        return Integer.parseInt(this.getNextToken().trim());
    }

    public void skip(int numTokens) throws IOException {
        try {
            while (numTokens-- > 0) {
                this.getNextToken();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public String getNextToken() throws IOException {
        switch (this.stream.nextToken()) {
            case -1: {
                throw new EOFException();
            }
        }
        if (this.stream.sval == null) {
            throw new EOFException();
        }
        return this.stream.sval;
    }

    public void setMark() throws IOException {
        this.setMark(10000);
    }

    public void setMark(int readAheadLimit) throws IOException {
        if (!this.reader.markSupported()) {
            throw new IOException("Mark not supported on stream!");
        }
        this.reader.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }
}

