/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class NmxByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private int writePosition = 0;
    private boolean growable = true;

    public NmxByteArrayOutputStream() {
        this(32);
    }

    public NmxByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public NmxByteArrayOutputStream(byte[] buf, boolean growable) {
        this.buf = buf;
        this.growable = growable;
    }

    public synchronized void write(int b) throws IOException {
        int newcount = this.writePosition + 1;
        if (newcount > this.buf.length) {
            if (!this.isGrowable()) {
                throw new IOException("Reached end of buffer!");
            }
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.writePosition] = (byte)b;
        if (this.count < this.writePosition + 1) {
            this.count = this.writePosition + 1;
        }
        ++this.writePosition;
    }

    public boolean isGrowable() {
        return this.growable;
    }

    public void setGrowable(boolean growable) {
        this.growable = growable;
    }

    public int getWritePosition() {
        return this.writePosition;
    }

    public void setWritePosition(int position) throws IOException {
        if (position < 0) {
            throw new IOException("Invalid position!");
        }
        this.writePosition = position;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.writePosition + len;
        if (newcount > this.buf.length) {
            if (!this.isGrowable()) {
                throw new IOException("Reached end of buffer!");
            }
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.writePosition, len);
        if (this.count < this.writePosition + len) {
            this.count = this.writePosition + len;
        }
        this.writePosition += len;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
        this.writePosition = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    public void close() throws IOException {
    }
}

