/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.NmxByteArrayOutputStream;
import ca.nanometrics.io.NmxDataInputIF;
import ca.nanometrics.io.NmxDataOutputStream;
import ca.nanometrics.io.StreamInputListenerIF;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class NmxDataInputStream
extends FilterInputStream
implements NmxDataInputIF {
    private URI m_baseURI;
    private Vector readListeners = new Vector();
    private char[] lineBuffer;

    public NmxDataInputStream(InputStream in, URI base) {
        super(in);
        this.setBaseURI(base);
    }

    public NmxDataInputStream(InputStream in) {
        this(in, null);
    }

    public NmxDataInputStream(NmxDataInputStream clone, InputStream in) {
        this(in, clone.getBaseURI());
    }

    public void setBaseURI(URI base) {
        this.m_baseURI = base;
    }

    public URI getBaseURI() {
        return this.m_baseURI;
    }

    public void addInputListener(StreamInputListenerIF obs) {
        this.readListeners.add(obs);
    }

    public void removeInputListener(StreamInputListenerIF obs) {
        this.readListeners.remove(obs);
    }

    public URI readURI() throws IOException {
        return NmxDataInputStream.readURI(this, this.m_baseURI);
    }

    public URL readURL() throws IOException {
        return NmxDataInputStream.readURL(this);
    }

    public URL readURL(short length) throws IOException {
        NmxByteArrayOutputStream bStream = new NmxByteArrayOutputStream();
        NmxDataOutputStream tempStream = new NmxDataOutputStream(bStream);
        tempStream.writeShort(length);
        byte[] b = new byte[length];
        this.readFully(b);
        tempStream.write(b);
        ByteArrayInputStream bs = new ByteArrayInputStream(bStream.toByteArray());
        return NmxDataInputStream.readURL(new NmxDataInputStream(bs));
    }

    static URI readURI(DataInput stream, URI base) throws IOException {
        boolean wasRelativized = stream.readBoolean();
        URI data = null;
        try {
            data = new URI(stream.readUTF());
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        if (wasRelativized && base != null) {
            data = base.resolve(data);
        }
        return data;
    }

    static URL readURL(DataInput stream) throws IOException {
        URL data = null;
        try {
            data = new URL(stream.readUTF());
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        return data;
    }

    public int read() throws IOException {
        int dataRead = this.in.read();
        if (this.readListeners.size() > 0) {
            Iterator iter = this.readListeners.iterator();
            byte[] byteArray = new byte[]{(byte)dataRead};
            while (iter.hasNext()) {
                ((StreamInputListenerIF)iter.next()).bytesReadNotify(byteArray);
            }
        }
        return dataRead;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        if (length > 0 && this.readListeners.size() > 0) {
            Iterator iter = this.readListeners.iterator();
            byte[] byteArray = new byte[length];
            System.arraycopy(b, off, byteArray, 0, length);
            while (iter.hasNext()) {
                ((StreamInputListenerIF)iter.next()).bytesReadNotify(byteArray);
            }
        }
        return length;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public int skipBytes(int n) throws IOException {
        InputStream in = this.in;
        int total = 0;
        int cur = 0;
        while (total < n && (cur = (int)in.skip(n - total)) > 0) {
            total += cur;
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("ReadLine not supported!");
    }

    public final String readUTF() throws IOException {
        return NmxDataInputStream.readUTF(this);
    }

    public static String readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str);
    }

    public NmxDataInputIF cloneStream(InputStream stream) {
        return new NmxDataInputStream(this, stream);
    }
}

