/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.RandomAccessIF;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccess2InputStreamAdapter
extends InputStream {
    private RandomAccessIF file;
    private long markPosition = -1L;

    public RandomAccess2InputStreamAdapter(RandomAccessIF file) {
        this.file = file;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.markPosition = this.file.getPointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        return this.file.readUnsignedByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        if (this.markPosition < 0L) {
            throw new IOException("Mark not called!");
        }
        this.file.seek(this.markPosition);
        this.markPosition = -1L;
    }

    public long skip(long n) throws IOException {
        return this.file.skipBytes((int)n);
    }
}

