/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CalibrationInfoTable
implements Packable {
    public static final int MSG_TYPE = 151;
    public static final int INT_SIZE = 4;
    private Hashtable table = new Hashtable();

    public CalibrationInfoTable() {
    }

    public CalibrationInfoTable(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public CalibrationInfo add(CalibrationInfo info) {
        int key = info.getKey();
        return this.table.put(new Integer(key), info);
    }

    public boolean contains(int key) {
        return this.table.containsKey(new Integer(key));
    }

    public CalibrationInfo get(int key) {
        return (CalibrationInfo)this.table.get(new Integer(key));
    }

    public CalibrationInfo remove(int key) {
        return (CalibrationInfo)this.table.get(new Integer(key));
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public int size() {
        return this.table.size();
    }

    public void writeTo(byte[] buffer, int offset) {
        int numElements = this.size();
        BigEndian.writeInt(buffer, offset, numElements);
        offset += 4;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            CalibrationInfo info = (CalibrationInfo)e.nextElement();
            info.writeTo(buffer, offset);
            offset += info.getDataLength();
        }
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4 || offset + length < buffer.length) {
            throw new InvalidInputException("no data in CalibrationInfoTable.readFrom()");
        }
        int itemsToRead = BigEndian.readInt(buffer, offset);
        int bytesRead = 4;
        int item = 0;
        while (item < itemsToRead) {
            CalibrationInfo info = new CalibrationInfo(buffer, offset + bytesRead, length - bytesRead);
            this.add(info);
            bytesRead += info.getDataLength();
            ++item;
        }
    }

    public int getDataType() {
        return 151;
    }

    public int getDataLength() {
        int length = 4;
        Enumeration e = this.table.elements();
        while (e.hasMoreElements()) {
            CalibrationInfo info = (CalibrationInfo)e.nextElement();
            length += info.getDataLength();
        }
        return length;
    }
}

