/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.KeyedChannel;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ChannelList
implements Packable {
    public static final int MSG_TYPE = 150;
    public static final int NO_KEY = -1;
    static final int INT_SIZE = 4;
    static final int NAME_SIZE = 12;
    static final int ENTRY_SIZE = 16;
    static final int OFFSET_TO_SIZE = 0;
    static final int OFFSET_TO_DATA = 4;
    private Hashtable table = new Hashtable();

    public ChannelList() {
    }

    public ChannelList(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public void addElement(int key, String name) {
        this.table.put(name, new KeyedChannel(key, name));
    }

    public int size() {
        return this.table.size();
    }

    public boolean contains(int key) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            KeyedChannel chan = (KeyedChannel)e.nextElement();
            if (key != chan.getKey()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name) {
        return this.table.contains(name);
    }

    public String getNameOf(int key) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            KeyedChannel chan = (KeyedChannel)e.nextElement();
            if (key != chan.getKey()) continue;
            return chan.getName();
        }
        return null;
    }

    public int getKeyOf(String name) {
        KeyedChannel chan = (KeyedChannel)this.table.get(name);
        if (chan != null) {
            return chan.getKey();
        }
        return -1;
    }

    public void clear() {
        this.table.clear();
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public Iterator names() {
        return this.table.keySet().iterator();
    }

    public int getDataType() {
        return 150;
    }

    public int getDataLength() {
        return 4 + 16 * this.size();
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset + 0, this.size());
        offset += 4;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            KeyedChannel chan = (KeyedChannel)e.nextElement();
            BigEndian.writeInt(buffer, offset, chan.getKey());
            BigEndian.writeString(buffer, offset += 4, chan.getName(), 12);
            offset += 12;
        }
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.clear();
        int nsize = BigEndian.readInt(buffer, offset + 0);
        offset += 4;
        int i = 0;
        while (i < nsize) {
            int key = BigEndian.readInt(buffer, offset);
            String name = BigEndian.readString(buffer, offset += 4, 12);
            offset += 12;
            this.addElement(key, name);
            ++i;
        }
    }

    public String toString() {
        return "ChannelList (" + this.size() + " entries)";
    }
}

